importPackage(ru.yandex.misc.db.q);
importPackage(ru.yandex.inside.yt.kosher.cypress);
importPackage(ru.yandex.inside.yt.kosher.tables.types);
importPackage(com.fasterxml.jackson.databind.node);
importPackage(ru.yandex.inside.yt.kosher.impl);
importPackage(ru.yandex.misc.db.masterSlave);

new Array('', '0', '0V', '1B', '1I', '1V', '2', '2V', '2B', '3', '3B', '3I', '3V').forEach(function(suffix) {
    this['f' + suffix] = function(func) {
        return new (Java.extend(ru.yandex.bolts['function']['Function' + suffix], {
            apply: function() {
                return func.apply(this, arguments);
            }
        }))()
    };
});

var handleCounts = 100;
var handleCountsPerShard = Cf.map(74, 25,
                                 41, 50,
                                 7, 50,
                                 75, 50);
var pauseValuesPerShard = Cf.map(41, 100,
                                 7, 100,
                                 74, 100,
                                 75, 100);
var ytPageSize = 100000;
// Use your own path suffix
var rootFolder = '//home/datasync/...';

var threads = 7;

// var PROXY = "hahn.yt.yandex-team.ru";
// var TOKEN = "";
// var yt = YtUtils.http(PROXY, TOKEN);
var yt = dataApiYtClient;

var shards = dataShardManager.shards().toList();

var maxPartition = 128;

var jsonNodeFactory = new JsonNodeFactory(false);

var rowMapper = new org.springframework.jdbc.core.RowMapper{
    mapRow: function(rs, rowNum) {
        var node = jsonNodeFactory.objectNode();
        node.put('uid', rs.getString('uid'));
        node.put('handle', rs.getString('handle'));
        node.put('row_count', rs.getLong('row_count'));
        node.put('tb', rs.getString('tb'));
        return node;
    }
}

function getDatabases(shard, partitionIndex, offsetHandle) {
    var condition = offsetHandle.map(function (handle) {return ConditionUtils.column("handle").gt(handle);})
        .getOrElse(SqlCondition.trueCondition());
    var limits = SqlLimits.first(handleCountsPerShard.getO(shard.getShardInfo().getId()).getOrElse(handleCounts));
    var order = SqlOrder.orderByColumn("handle");

    var databasesPartition = 'databases_' + ru.yandex.misc.lang.StringUtils.leftPad(partitionIndex, 3, '0');
    var pDataPartition = 'p_data_' + ru.yandex.misc.lang.StringUtils.leftPad(partitionIndex, 3, '0');
    var deltasPartition = 'deltas_' + ru.yandex.misc.lang.StringUtils.leftPad(partitionIndex, 3, '0');

    var withSection = "WITH handles AS (SELECT user_id, handle FROM " + databasesPartition + " " + condition.whereSql() + " "
        + order.toSql() + " "
        + limits.toMysqlLimits() + ") ";

    var query = withSection + " SELECT MAX(p_data.user_id) AS uid, COUNT(*) AS row_count, handles.handle, 'p_data' AS tb FROM " + pDataPartition + " AS p_data JOIN handles USING(handle) GROUP BY handles.handle " +
        "UNION ALL "
        + "SELECT MAX(handles.user_id), COUNT(*), handles.handle, 'deltas' FROM " + deltasPartition + " AS deltas JOIN handles USING(handle) GROUP BY handles.handle";

    return shard.getJdbcTemplate3().query(query, rowMapper, condition.args());
}

function withRetries(action) {
    return ru.yandex.commune.util.RetryUtils.retryO(5, action).getOrThrow("failed on reties");
}

function uploadShardPartition(shard, partitionIndex) {
    var shardId = shard.getShardInfo().getId();
    var resultPath = YPath.simple(rootFolder + "/shard" + ru.yandex.misc.lang.StringUtils.leftPad(shardId, 3, '0') + "partition" + ru.yandex.misc.lang.StringUtils.leftPad(partitionIndex, 3, '0')).append(true);

    if (withRetries(function() { return yt.cypress().exists(resultPath) })) {
        return resultPath;
    }

    withRetries(function() {
        yt.cypress().create(resultPath, CypressNodeType.TABLE, true, true);
    });

    var handleOffset = Option.empty();

    var records = Cf.arrayList();

    do {
        var dbs = getDatabases(shard, partitionIndex, handleOffset);
        handleOffset = dbs.lastO().map(function(row) {return row.get('handle').asText()});
        dbs.forEach(function(row) {
            row.remove('handle');
        });

        records.addAll(dbs);

        if ((records.size() >= ytPageSize) || (dbs.isEmpty())) {
            withRetries(function () {
                yt.tables().write(resultPath, new JacksonTableEntryType(false), records);
            });
            records = Cf.arrayList();
        }
        java.lang.Thread.sleep(pauseValuesPerShard.getO(shardId).getOrElse(10));
    } while (dbs.isNotEmpty());
    return resultPath;
}

var futures = Cf.arrayList();

function uploadShard(shard) {
    var latch = new java.util.concurrent.CountDownLatch(maxPartition);
    var pathes = Cf.arrayList();
    Cf.range(0, maxPartition).forEach( function (partition) {
        futures.add(executor.submit(
            function () {
                MasterSlaveContextHolder.withPolicy(MasterSlavePolicy.R_ASYNC_S, f0V(function() {
                    pathes.add(uploadShardPartition(shard, partition));
                }));
                latch.countDown();
            },
            null));
    } );
    latch.await();
}

function uploadPartition(partition) {
    var latch = new java.util.concurrent.CountDownLatch(shards.size());
    var pathes = Cf.arrayList();
    shards.forEach( function (shard) {
        futures.add(executor.submit(
            function () {
                MasterSlaveContextHolder.withPolicy(MasterSlavePolicy.R_ASYNC_S, f0V(function() {
                    pathes.add(uploadShardPartition(shard, partition));
                }));
                latch.countDown();
            },
            null));
    } );
    latch.await();
}

var getTasksStatistics = function(tasks) {
    var stat = {};
    stat.count = tasks.size();
    stat.doneCount = tasks.filter(function(task) {
        return task.isDone();
    }).size();
    return stat.toSource();
}

try {
     executor = java.util.concurrent.Executors.newFixedThreadPool(threads);
     //shards.forEach(function (shard) {
     //    uploadShard(shard);
     //})

     Cf.range(0, maxPartition).forEach(function (partition) {
         uploadPartition(partition);
     })
} finally {
     executor.shutdown();
}