import Queue
import json
import threading
import traceback
import urlparse

from compare_mpfs_djfs_bulk import get_data, MPFS_HOST, DJFS_HOST, same, print_diff, remove_duplicates_in_file_ids

console_lock = threading.Lock()

class CompareThread(threading.Thread):
    def __init__(self, lines_queue, results_queue, results_thread, endpoint):
        threading.Thread.__init__(self)
        self.lines_queue = lines_queue
        self.results_queue = results_queue
        self.daemon = True
        self.receive_messages = True
        self.source_file_ended = False
        self.results_thread = results_thread
        self.endpoint = endpoint

    def run(self):
        while self.receive_messages:
            if self.source_file_ended:
                self.results_thread.dec_running_comparators()
                print 'exiting'
                return

            try:
                val = self.lines_queue.get(timeout=5)
                self.process_message(val['_id'], val['line'], self.endpoint)
            except Queue.Empty as e:
                print 'queue is empty'

    def process_message(self, _id, line, endpoint):
        try:
            body = None
            if '\t' in line:
                body, uri = line[:-1].split('\t')
            else:
                uri = line[:-1]

            if body:
                body = remove_duplicates_in_file_ids(body)

            uid = urlparse.parse_qs(urlparse.urlparse(uri).query)['uid'][0] if 'uid' in urlparse.parse_qs(urlparse.urlparse(uri).query) else None

            mpfs_response = get_data(MPFS_HOST, uri, endpoint, body)
            djfs_response = get_data(DJFS_HOST, uri, endpoint, body)

            if not mpfs_response and not djfs_response:
                self.report_success(_id)
                return
            if not mpfs_response or not djfs_response:
                print_diff('', '', '', _id, uri, True, body)
                self.report_error('ERROR in one of responses, ID :', _id)
                return

            mpfs_data = json.loads(mpfs_response.text)
            djfs_data = json.loads(djfs_response.text)

            if same(mpfs_data, djfs_data, uid, _id, uri, endpoint, body):
                self.report_success(_id)
            else:
                self.report_error('NOT_MATCHED: ', _id)
        except Exception as e:
            self.report_error('ERROR: ', _id, e)

    def stop(self):
        self.receive_messages = False

    def set_source_file_ended(self):
        self.source_file_ended = True

    def report_error(self, message, _id, exception=None):
        self.results_queue.put(_id)
        with console_lock:
            print message + str(_id)
            if exception:
                print exception
                traceback.print_exc()

    def report_success(self, _id):
        self.results_queue.put(_id)
        if (_id % 5000 == 0):
            with console_lock:
                print 'SUCCESS: ' + str(_id)
