importPackage(ru.yandex.commune.zk2);
importPackage(ru.yandex.misc.io.file);
importPackage(ru.yandex.chemodan.app.docviewer.convert);
importClass(ru.yandex.misc.log.mlf.LoggerFactory);
importPackage(ru.yandex.inside.yt.kosher.cypress);
importPackage(ru.yandex.inside.yt.kosher.tables);
importPackage(java.nio.file);
importPackage(java.nio.charset);
importPackage(ru.yandex.chemodan.util.yt);
importPackage(ru.yandex.inside.yt.kosher.impl);
importPackage(java.util.concurrent);

var zk = zkPathObserver.zk();

var enabled = new ZkPath('/docviewer/production/dyn-properties/docviewer-cleanup-enabled-boolean');
var batchSize = new ZkPath('/docviewer/production/dyn-properties/docviewer-cleanup-batch-size-int');
var offset = new ZkPath('/docviewer/production/dyn-properties/docviewer-cleanup-offset-int');
var poolSize = new ZkPath('/docviewer/production/dyn-properties/docviewer-cleanup-pool-size-int');

var defaultEnabled = true;
var defaultBatchSize = 1000;
var defaultOffset = 0;
var defaultPoolSize = 10;
var tokenPath = '/home/messiahlap/yql.token'
var size = 916017619;
var ytPath = '//home/disk-dev/yashunsky/CHEMODAN-64038/to_clean_from_yt';
var linesCounter = new java.util.concurrent.atomic.AtomicInteger(0);
var totalCounter = new java.util.concurrent.atomic.AtomicInteger(0);
var toDeleteCounter = new java.util.concurrent.atomic.AtomicInteger(0);

new Array('', '0', '0V', '1B', '1I', '1V', '2', '2V', '2B', '3', '3B', '3I', '3V').forEach(function(suffix) {
    this['f' + suffix] = function(func) {
        return new (Java.extend(ru.yandex.bolts['function']['Function' + suffix], {
            apply: function() {
                return func.apply(this, arguments);
            }
        }))()
    };
});

var logger = LoggerFactory.getLogger('docviewer-cleanup-session');

var getZkValue = function(zkPath) {
	return zk.getDataIfExists(zkPath).map(function(bytes) {
		return new java.lang.String(bytes);
	});
};

var setZkValue = function(zkPath, value) {
	zk.setData(zkPath, java.lang.String.valueOf(value).getBytes());
};

var getIntZkValue = function(zkPath) {
	return getZkValue(zkPath).map(function(string) {
		return java.lang.Integer.parseInt(string);
	})
};

var getBoolZkValue = function(zkPath) {
	return getZkValue(zkPath).map(function(string) {
		return java.lang.Boolean.valueOf(string);
	})
};

var cleanupByYt = function() {
	var startPosition = getIntZkValue(offset).getOrElse(defaultOffset);
	var poolSizeValue = getIntZkValue(poolSize).getOrElse(defaultPoolSize);
	var batchSizeValue = getIntZkValue(batchSize).getOrElse(defaultBatchSize);
	logger.info('Start docviewer cleanup start_position={} pool_size={} batch_size={}', startPosition, poolSizeValue, batchSizeValue);
	var executer = java.util.concurrent.Executors.newFixedThreadPool(poolSizeValue, new ru.yandex.misc.thread.factory.ThreadNameIndexThreadFactory("docviewer-cleanup"));
	var semaphore = new java.util.concurrent.Semaphore(poolSizeValue);
	var ytHelper = getYtHelper();
	try {
		for (var i = startPosition; i < size; i += batchSizeValue) {
		    if (!getBoolZkValue(enabled).getOrElse(true)) {
			    logger.info('the cleanup has been disabled');
			    break;
		    }
	        var limit = new java.util.concurrent.atomic.AtomicInteger(Math.min(i + batchSizeValue, size));
	        var path = YPath.simple(ytPath).withRange(i, limit);
	        var counter = new java.util.concurrent.atomic.AtomicInteger(0);
	        var disabled = false;

            ytHelper.tables().read(path, YTableEntryTypes.JACKSON, f1V(function (node) {
                if (!disabled && counter.get() > 0 && counter.get() % 1000 === 0 && !getBoolZkValue(enabled).getOrElse(true)) {
                    logger.info('the cleanup has been disabled counter={}', counter.get());
                    disabled = true;
                    limit.set(i + counter);
                }
                counter.incrementAndGet();
                if (disabled) {
                    return;
                }
                var id = node.get("id");
                semaphore.acquire();
                executer.submit(new java.lang.Runnable(function() {
                    try {
                	    consume(id.asText())
                    } catch (e) {
                        logger.error('failed to delete {}: {}', id, e)
                    } finally {
                        semaphore.release();
                    }
                }))
            }));
            logger.info('processed {} items, start iteration {}', limit.get(), i);
            setZkValue(offset, limit.get());
        }
    } finally {
        executer.shutdown();
    }
}

var getYtHelper = function() {
	var token = new java.lang.String(Files.readAllBytes(Paths.get(tokenPath)), StandardCharsets.UTF_8).trim();
	var yt = YtUtils.http('hahn.yt.yandex.net', token);
	return yt;
}

invoke = function(obj, name, varargs) {
    return ru.yandex.misc.reflection.MethodX.getSingleMethod(obj.getClass(), name)
        .setAccessibleTrueReturnThis()
        .invoke(obj, arguments.length > 2 ? Array.prototype.slice.call(arguments, 2) : []);
};

function deleteHandler(storedResult) {
    logger.info("processed {} results. current last access is {}", totalCounter.incrementAndGet(), storedResult.getLastAccess());
    if (!invoke(resultsCleanup, 'skipResult', storedResult)) {
        invoke(resultsCleanup, 'cleanupStoredResult', storedResult);
        logger.info("line {}. deleting file {} with last access time: {}", linesCounter.get(), toDeleteCounter.incrementAndGet(), storedResult.getLastAccess());
    }
}

function consume(line) {
	linesCounter.incrementAndGet();
    var parts = line.split(' ');
    var fileId = parts[0];
    var convertTargetType = TargetType.valueOf(parts[1], null);
    var storedResultO = storedResultDao.find(fileId, convertTargetType);
    if (storedResultO.isPresent()) {
        deleteHandler(storedResultO.get());
    }
}


cleanupByYt();
