import Queue
import threading

comparators_cnt_lock = threading.Lock()


class DumpResultsThread(threading.Thread):
    def __init__(self, queue, init_offset, running_comparators_cnt):
        threading.Thread.__init__(self)
        self.results_queue = queue
        self.daemon = True
        self.receive_messages = True
        self.results = set()
        self.min_unprocessed = init_offset
        self.running_comparators_cnt = running_comparators_cnt
        self.comparators_cnt_lock = threading.Lock()

    def run(self):
        while self.receive_messages:
            if self.running_comparators_cnt == 0 and self.results_queue.empty():
                print 'Results queue is empty, comparators stopped'
                break
            try:
                val = self.results_queue.get(timeout=5)
                self.process_message(val)
            except Queue.Empty as e:
                print 'results queue is empty'

    def dec_running_comparators(self):
        with self.comparators_cnt_lock:
            self.running_comparators_cnt = self.running_comparators_cnt - 1
            print 'Comparators thread count decreasing. Current count: ', self.running_comparators_cnt

    def process_message(self, _id):
        if _id == self.min_unprocessed:
            self.min_unprocessed = _id + 1
            while self.min_unprocessed in self.results:
                self.results.remove(self.min_unprocessed)
                self.min_unprocessed = self.min_unprocessed + 1
            with open('last_unprocessed.txt', 'w') as f:
                f.write(str(self.min_unprocessed))
        else:
            self.results.add(_id)

    def stop(self):
        self.receive_messages = False
