importPackage(ru.yandex.inside.passport);
importPackage(org.joda.time);
importClass(ru.yandex.misc.log.mlf.LoggerFactory);
importPackage(ru.yandex.inside.yt.kosher.cypress);
importPackage(ru.yandex.inside.yt.kosher.tables);
importPackage(java.nio.file);
importPackage(java.nio.charset);
importPackage(ru.yandex.chemodan.util.yt);
importPackage(ru.yandex.inside.yt.kosher.impl);
importPackage(java.util.concurrent);
importPackage(java.lang.String)
importPackage(ru.yandex.chemodan.app.dataapi.api.deltas);
importPackage(ru.yandex.chemodan.app.dataapi.api.data.field);
importPackage(ru.yandex.chemodan.app.dataapi.api.user);
importPackage(ru.yandex.chemodan.app.dataapi.api.db)
importPackage(ru.yandex.chemodan.app.dataapi.api.db.ref);
importPackage(ru.yandex.chemodan.app.dataapi.api.data.filter.condition);
importPackage(ru.yandex.chemodan.app.dataapi.api.deltas.RevisionCheckMode);
importPackage(ru.yandex.bolts.collection.impl);
importPackage(ru.yandex.commune.util);
importPackage(ru.yandex.misc.db.masterSlave);

var uidsToSend = Cf.x(['480353447']);
var uidsToExclude = Cf.set(['1130000039973156', '1013656460', '1013656999', '1013656430', '1013656535', '1013657033', '1013656384', '1013656391', '1013656035', '1013657081', '1013656003',
	'887833386', '887833347', '887833400', '887832545', '887832566', '887832376', '887832400', '887833330', '887831612', '887831396', '887831631', '887832824', '887833854', '887833593', '887832283',
	'887832245', '887832265', '1013656082', '947043426']);
var ytPath = '//home/disk-dev/messiahlap/promo_notifications_test_1';
var step = 10000;
var size = 1;
var offset = 0;
var app = "yadisk";
var dbName = "notifications";
var cooldown = 72 * 60 * 60 * 1000; // время между нотификациями 72h
var poolSizeValue = 10;
var counter = new java.util.concurrent.atomic.AtomicInteger();

new Array('', '0', '0V', '1B', '1I', '1V', '2', '2V', '2B', '3', '3B', '3I', '3V').forEach(function(suffix) {
    this['f' + suffix] = function(func) {
        return new (Java.extend(ru.yandex.bolts['function']['Function' + suffix], {
            apply: function() {
                return func.apply(this, arguments);
            }
        }))()
    };
});

var logger = LoggerFactory.getLogger('send_promo_pushes_prod');


var sendPushToUid = function(uid) {
	MasterSlaveContextHolder.withPolicy(MasterSlavePolicy.RW_M,
		f0(function() {
	        var dbSpec = new UserDatabaseSpec(DataApiUserId.parse(uid), DatabaseRef.cons(Option.of(app), dbName));
            dataApiManager.deleteDatabaseIfExists(dbSpec, DatabaseDeletionMode.REMOVE_COMPLETELY);
            var db = dataApiManager.createDatabase(dbSpec);
            var notifications = Cf.list(
                RecordChange.insert("notifications", 1, Cf.map()
                    .plus1("priority", DataField.integer(1))
                    .plus1("statistics_id", DataField.string("abc"))
                    .plus1("send_date", DataField.timestamp(new Instant(1545224048734)))
                    .plus1("end_date", DataField.timestamp(new Instant(1924894800000)))
                    .plus1("link", DataField.string("https://business.yandex.ru/disk/promo?utm_campaign=200gb_promo&utm_medium=teaser&utm_source=disk"))
                    .plus1("link_new_window", DataField.bool(true))
                    .plus1("title_ru", DataField.string("Диск для бизнеса бесплатно"))
                    .plus1("title_en", DataField.string("Disk for business for free"))
                    .plus1("title_tr", DataField.string("Kurumlar için Disk fırsatı"))
                    .plus1("title_uk", DataField.string("Диск для бізнесу безкоштовно"))
                    .plus1("text_ru", DataField.string("Получите 200 ГБ для каждого сотрудника и используйте бесплатно до 30 сентября."))
                    .plus1("text_en", DataField.string("Get 200 GB for each employee and use for free until September 30."))
                    .plus1("text_tr", DataField.string("Çalışan başına 200 GB Disk alanı alın, 30 Eylül'e kadar ücretsiz kullanın"))
                    .plus1("text_uk", DataField.string("Отримайте 200 ГБ для кожного співробітника та використовуйте безкоштовно до 30 вересня."))
                    .plus1("link_text_ru", DataField.string("Попробовать"))
                    .plus1("link_text_en", DataField.string("Try now"))
                    .plus1("link_text_tr", DataField.string("Dene"))
                    .plus1("link_text_uk", DataField.string("Спробувати"))
                 )
            );
            var notificationsDelta = new Delta(notifications);
            dataApiManager.applyDelta(db, RevisionCheckMode.WHOLE_DATABASE, notificationsDelta);

            var settings = RecordChange.insert("settings", "1", Cf.map()
                .plus1("name", DataField.string("cooldown"))
                .plus1("value", DataField.integer(cooldown))
            );
            return dataApiManager.applyDelta(db, settings, RecordCondition.all());
        }));
}


var sendToKnownSet = function() {
	logger.info('Start send promo pushes by set');
	uidsToSend.forEach(function(uid) {
	   logger.info('Start processing uid={}', uid);
	   RetryUtils.retry(logger, 3, f0(function() { return sendPushToUid(uid) }));
    });
}

var sendByYt = function() {
	logger.info('Start send promo pushes by YT');
	var executer = java.util.concurrent.Executors.newFixedThreadPool(poolSizeValue, new ru.yandex.misc.thread.factory.ThreadNameIndexThreadFactory("send_promo_pushes"));
	var ytHelper = getYtHelper();
	var semaphore = new Semaphore(poolSizeValue);
	for (var i = offset; i < size; i += step) {
	    var path = YPath.simple(ytPath).withRange(i, Math.min(i + step, size))

        ytHelper.tables().read(path, YTableEntryTypes.JACKSON, f1V(function (node) {
            var accountId = node.get("puid");
            if (!accountId) {
                return;
            }
            var finalUid = accountId.asText().trim();
            if (uidsToExclude.contains(finalUid)) {
            	logger.info('The uid={} has been excluded', finalUid);
            	counter.incrementAndGet();
            	return;
            }
            semaphore.acquire();
            executer.submit(new java.lang.Runnable(function() {
                try {
                	logger.info('Start processing uid={}', finalUid);
                	RetryUtils.retry(logger, 5, 10, 2, f0(function() { return sendPushToUid(finalUid) }));
                	logger.info('The notification has been sent for uid={} counter={}', finalUid, counter.incrementAndGet());
                } catch (e) {
                	logger.warn('Error for uid={} counter={}', finalUid, counter.incrementAndGet());
                	logger.warn(e);
                } finally {
                	semaphore.release();
                }
            }));
        }));
    }
    executer.shutdown();
}

var getYtHelper = function() {
	return coolLentaYtHelper;
}

//sendByYt();
//sendToKnownSet();


