#!/bin/bash -e

export LANG=C
export LC_MESSAGES=C
export LC_ALL=C

SVN_REVISION="unknown"
SVN_URL="unknown"

cd $(dirname $0)
cd ..

devel/ya svn info >/dev/null 2>&1
SVN_REVISION=$(devel/ya svn info | sed -n 's/^Last Changed Rev: \(.*\)$/\1/p')
SVN_URL=$(devel/ya svn info | sed -n 's,^URL: ,,p')
version=$(devel/deb_version.sh)

echo "project.version: $version"
echo "project.svn.rev: $SVN_REVISION"
echo "project.svn.url: $SVN_URL"
echo "build.date: $(date)"
echo "build.host: $(hostname -f)"
echo "build.user: $(whoami)"

# vim: set ts=4 sw=4 et:
