importClass(ru.yandex.chemodan.app.notifier.notification.NotificationType)
importClass(ru.yandex.chemodan.app.notifier.notification.NotificationVariant)
importClass(ru.yandex.chemodan.app.notifier.tanker.TankerMessageKey)
importClass(ru.yandex.misc.lang.Check)

type_name = "photo_selection_cool_lenta_one_day"

global_vars_per_type = 2;

titles1 = Cf.list("photo_selection_cool_lenta_common_title_v1_1", "photo_selection_cool_lenta_common_title_v1_2", "photo_selection_cool_lenta_common_title_v1_3")
titles2 = Cf.list("photo_selection_cool_lenta_common_title_v2_1", "photo_selection_cool_lenta_common_title_v2_2", "photo_selection_cool_lenta_common_title_v2_3")

new_variants = Cf.arrayList()

function checkTranslations(key) {
    translations = tankerManager.getAllTranslations(new TankerMessageKey("notifier-notifications", key))
    Check.notEmpty(translations.keys(), "no translations for " + key)
    Check.isEmpty(translations.keySet().minus(Cf.list("en", "ru", "tr", "uk")), "No translations for some languages for key=" + key + " lang = " + translations.keys())
    for (var i = 0; i < translations.keys().size(); i++) {
        var lang = translations.keys().get(i)
        var trans = translations.get(lang)
        Check.some(trans.form, "No default form given for " + key)
    }
}

function getRuText(key) {
    return tankerManager.getAllTranslations(new TankerMessageKey("notifier-notifications", key)).get("ru").form.get().text;
}

function buildVariants(title_id, titles, vars_per_type) {
  variants = Cf.arrayList()
  for (var j = 0; j < titles.size(); j++) {
      for (var i = 1; i <= vars_per_type; i++) {
          title = titles.get(j)
          short = type_name + "_short_t1" + "_v" + i;
          var_name = "n1_" + "t_" + title_id + "_" + j + "_v" + i;

          print (var_name + " : " + title  +  " / " + short);

          variants.add(new NotificationVariant(var_name, 0.0, 0.0, Option.empty(), Option.empty(),
              Option.of(title), Option.of(short),
              Option.empty(), Option.empty()
          ));

          checkTranslations(title)
          checkTranslations(short)
      }
  }
  return variants
}

new_variants.addAll(buildVariants(1, titles1, global_vars_per_type))
new_variants.addAll(buildVariants(2, titles2, global_vars_per_type))

print("")

for (var i = 0; i < new_variants.size(); i++) {
    var v = new_variants.get(i)
    print (getRuText(v.titleMessageKey.get()) + " / " + getRuText(v.shortMessageKey.get()))
}

type = notifierTypesRegistry.getAllTypes().find(function(x){return x.name.equals(type_name)}).get()
type = type.withAlternativeVariants(type.alternativeVariants.plus(new_variants))

notifierTypesRegistry.saveType(type)

print(type)