importClass(ru.yandex.misc.log.mlf.LoggerFactory);
importPackage(ru.yandex.chemodan.app.dataapi.api.deltas);
importPackage(ru.yandex.chemodan.app.dataapi.api.data.field);
importPackage(ru.yandex.chemodan.app.dataapi.api.user);
importPackage(ru.yandex.chemodan.app.dataapi.api.db.ref);
importPackage(ru.yandex.chemodan.app.dataapi.api.data.filter.condition);

var logger = LoggerFactory.getLogger("promo-notifier");

var start_date_str = "2019-02-13T00:00:00.00+0300"
var end_date_str = "2019-02-18T00:00:00.00+0300"

var executer = java.util.concurrent.Executors.newFixedThreadPool(100, new ru.yandex.misc.thread.factory.ThreadNameIndexThreadFactory("promo-notifier"));

var uids_1 = Cf.list()
var uids_2 = Cf.list()
var uids_3 = Cf.list()

var uids_1 = (new File2("/tmp/notifier_uids_1.txt")).readLines().flatMap(function(x){return Cf.Long.parseSafe(x)}).unique();
var uids_2 = (new File2("/tmp/notifier_uids_2.txt")).readLines().flatMap(function(x){return Cf.Long.parseSafe(x)}).unique();
var uids_3 = (new File2("/tmp/notifier_uids_3.txt")).readLines().flatMap(function(x){return Cf.Long.parseSafe(x)}).unique();

//uids_3 = Cf.list(558551043, 50273844)

var uids = uids_1.plus(uids_2).plus(uids_3);

var commonParts = Cf.map()
    .plus1("send_date", DataField.timestamp(DateTime.parse(start_date_str).toInstant()))
    .plus1("end_date", DataField.timestamp(DateTime.parse(end_date_str).toInstant()))
    .plus1("link_new_window", DataField.bool(true))
    .plus1("priority", DataField.integer(1));

function sendPromo(rawUid, fields) {
    var uid = DataApiUserId.parse("" + rawUid)
    for (var iii = 0; iii < 3; iii += 1) {
        try {
            var db = dataApiManager.getOrCreateDatabase(
                new UserDatabaseSpec(
                    uid,
                    DatabaseRef.cons(Option.of("yadisk"), "notifications")
                )
            );

            var notification = RecordChange.set(
                "notifications",
                "1",
                fields
            );

            var settings = RecordChange.set(
                "settings",
                "1",
                Cf.map()
                    .plus1("name", DataField.string("cooldown"))
                    .plus1("value", DataField.integer(259200000))
            );

            dataApiManager.applyDelta(db, RevisionCheckMode.PER_RECORD, new Delta(Cf.list(notification, settings)));
            logger.info("Sent promo for uid={}", uid);
            break
        } catch (e) {
            if (iii == 2) {
                logger.debug("Failed to send promo for uid={} : {}", uid, e);
            } else {
                logger.error("Retry send promo for uid={} : {}", uid, e);
            }
        }
    }
}

function sendPromo1(uid) {
    var type = "ufo_notifications_13_02_19_overdraft_group_1";
    logger.info("Sending promo notification: uid={}, type={}", uid, type);

    sendPromo(uid, commonParts
        .plus1("statistics_id", DataField.string(type))
        .plus1("link", DataField.string("/tuning?from=overdraft1"))
        .plus1("title_ru", DataField.string("Диск может работать медленнее обычного"))
        .plus1("title_en", DataField.string("Yandex.Disk may slow down"))
        .plus1("title_tr", DataField.string("Servis yavaşlayabilir"))
        .plus1("title_uk", DataField.string("Швидкість роботи сервісу може знизитися"))
        .plus1("text_ru", DataField.string("У вас закончилось место. Удалите ненужные файлы или увеличьте объём Диска."))
        .plus1("text_en", DataField.string("Your Disk is low on space. Some features may work slower than usual. Delete files you don't need or get extra space."))
        .plus1("text_tr", DataField.string("Disk alanınız doldu. Bazı özelliklerin hızı düşebilir. Gereksiz dosyaları silin veya Disk alanınızı artırın."))
        .plus1("text_uk", DataField.string("На вашому Диску закінчилось місце. Швидкість деяких функцій може знизитися. Видаліть зайві файли або збільште розмір Диска. "))
        .plus1("link_text_ru", DataField.string("Увеличить объем"))
        .plus1("link_text_en", DataField.string("Buy space"))
        .plus1("link_text_tr", DataField.string("Alan satın al"))
        .plus1("link_text_uk", DataField.string("Купити місце"))
    )
}

function sendPromo2(uid) {
    var type = "ufo_notifications_13_02_19_overdraft_group_2";
    logger.info("Sending promo notification: uid={}, type={}", uid, type);

    sendPromo(uid, commonParts
        .plus1("statistics_id", DataField.string(type))
        .plus1("link", DataField.string("/tuning?from=overdraft2"))
        .plus1("title_ru", DataField.string("Публичные ссылки недоступны"))
        .plus1("title_en", DataField.string("Public links disabled"))
        .plus1("title_tr", DataField.string("Açık bağlantılara erişemeyebilirsiniz"))
        .plus1("title_uk", DataField.string("Публічні посилання будуть не доступні"))
        .plus1("text_ru", DataField.string("Ваши файлы занимают больше места, чем вам доступно, поэтому вы не можете делиться ссылками на них. Удалите лишнее или увеличьте объём Диска."))
        .plus1("text_en", DataField.string("Your files are taking up more space than you have available. Some features have been disabled. Delete files you don't need or get extra space."))
        .plus1("text_tr", DataField.string("Dosyalarınız sahip olduğunuz alandan daha fazla yer kaplıyor. Bazı özellikleri engellemek zorundayız. Gereksiz dosyaları silin veya Disk alanınızı artırın."))
        .plus1("text_uk", DataField.string("Ваші файли займають більше місця, ніж вам доступно. Ми змушені обмежити функціонал. Видаліть зайві файли або збільште розмір Диска. "))
        .plus1("link_text_ru", DataField.string("Увеличить объем"))
        .plus1("link_text_en", DataField.string("Buy space"))
        .plus1("link_text_tr", DataField.string("Alan satın al"))
        .plus1("link_text_uk", DataField.string("Купити місце"))
    )
}

function sendPromo3(uid) {
    var type = "ufo_notifications_13_02_19_overdraft_group_3";
    logger.info("Sending promo notification: uid={}, type={}", uid, type);

    sendPromo(uid, commonParts
        .plus1("statistics_id", DataField.string(type))
        .plus1("link", DataField.string("/tuning?from=overdraft3"))
        .plus1("title_ru", DataField.string("Диск может быть заморожен"))
        .plus1("title_en", DataField.string("Yandex.Disk may be deactivated"))
        .plus1("title_tr", DataField.string("Disk'inize erişilemeyebilir"))
        .plus1("title_uk", DataField.string("Ваш Диск може бути заморожено"))
        .plus1("text_ru", DataField.string("Ваши файлы занимают больше места, чем вам доступно, поэтому Диск может быть переведён в неактивный режим. Удалите лишнее или увеличьте объём Диска."))
        .plus1("text_en", DataField.string("Your files occupy more space than is available to you. Your Disk may be deactivated. Delete files you don't need or get extra space."))
        .plus1("text_tr", DataField.string("Dosyalarınız sahip olduğunuz alandan daha fazla yer kaplıyor. Disk pasif moda geçirilebilir. Gereksiz dosyaları silin veya Disk alanınızı artırın."))
        .plus1("text_uk", DataField.string("Файли займають більше місця, ніж вам доступно. Диск може бути переведено у неактивний режим. Видаліть зайві файли або збільште розмір Диска. "))
        .plus1("link_text_ru", DataField.string("Увеличить объем"))
        .plus1("link_text_en", DataField.string("Buy space"))
        .plus1("link_text_tr", DataField.string("Alan satın al"))
        .plus1("link_text_uk", DataField.string("Купити місце"))

    )
}

function sendPromoByUid(uid) {
    if (uids_1.contains(uid)) {
        sendPromo1(uid);
    } else if (uids_2.contains(uid)) {
        sendPromo2(uid);
    } else if (uids_3.contains(uid)) {
        sendPromo3(uid);
    }
}

uids.forEach(function(uid) {
    var finalUid = uid
    executer.submit(new java.lang.Runnable(function() {sendPromoByUid(finalUid);}));
});

executer.shutdown();