importClass(ru.yandex.misc.log.mlf.LoggerFactory);
importPackage(ru.yandex.chemodan.app.dataapi.api.deltas);
importPackage(ru.yandex.chemodan.app.dataapi.api.data.field);
importPackage(ru.yandex.chemodan.app.dataapi.api.user);
importPackage(ru.yandex.chemodan.app.dataapi.api.db.ref);
importPackage(ru.yandex.chemodan.app.dataapi.api.data.filter.condition);

var logger = LoggerFactory.getLogger("promo-notifier");

var start_date_str = "2019-02-28T00:00:00.00+0300"
var end_date_str = "2019-03-11T00:00:00.00+0300"

var executer = java.util.concurrent.Executors.newFixedThreadPool(100, new ru.yandex.misc.thread.factory.ThreadNameIndexThreadFactory("promo-notifier"));

var uids_1 = Cf.list()
var uids_2 = Cf.list()
var uids_3 = Cf.list()
var uids_4 = Cf.list()

//var uids_1 = (new File2("/tmp/notifier_uids_1.txt")).readLines().flatMap(function(x){return Cf.Long.parseSafe(x)}).unique();
//var uids_2 = (new File2("/tmp/notifier_uids_2.txt")).readLines().flatMap(function(x){return Cf.Long.parseSafe(x)}).unique();
//var uids_3 = (new File2("/tmp/notifier_uids_3.txt")).readLines().flatMap(function(x){return Cf.Long.parseSafe(x)}).unique();
//var uids_4 = (new File2("/tmp/notifier_uids_4.txt")).readLines().flatMap(function(x){return Cf.Long.parseSafe(x)}).unique();

//uids_1 = Cf.list(50273844, 582231869)
//uids_2 = Cf.list(50273844, 582231869)
//uids_3 = Cf.list(50273844, 582231869)
//uids_4 = Cf.list(50273844, 582231869)

var uids = uids_1.plus(uids_2).plus(uids_3).plus(uids_4);

var commonParts = Cf.map()
    .plus1("send_date", DataField.timestamp(DateTime.parse(start_date_str).toInstant()))
    .plus1("end_date", DataField.timestamp(DateTime.parse(end_date_str).toInstant()))
    .plus1("link_new_window", DataField.bool(true))
    .plus1("priority", DataField.integer(1))
    .plus1("title_ru", DataField.string("Безлимитный Диск для телефона"))
    .plus1("title_en", DataField.string("Unlimited Disk space for your phone"))
    .plus1("title_tr", DataField.string("Telefonunuz için limitsiz Disk"))
    .plus1("title_uk", DataField.string("Безлімітний Диск для телефону"))
    .plus1("text_ru", DataField.string("Храните бесплатно сколько угодно снимков с телефона в приложении Диска"))
    .plus1("text_en", DataField.string("Store as many pics from your phone as you want in the Yandex.Disk app — it's free!"))
    .plus1("text_tr", DataField.string("İstediğiniz kadar fotoğrafı Yandex.Disk'te ücretsiz saklayın"))
    .plus1("text_uk", DataField.string("Зберігайте безкоштовно скільки завгодно знімків з телефону у програмі Яндекс.Диск"))
    .plus1("link_text_ru", DataField.string("Подробнее"))
    .plus1("link_text_en", DataField.string("Learn more"))
    .plus1("link_text_tr", DataField.string("Daha fazla bilgi]"))
    .plus1("link_text_uk", DataField.string("Детальніше"));

function sendPromo(rawUid, fields) {
    var uid = DataApiUserId.parse("" + rawUid)
    for (var iii = 0; iii < 3; iii += 1) {
        try {
            var db = dataApiManager.getOrCreateDatabase(
                new UserDatabaseSpec(
                    uid,
                    DatabaseRef.cons(Option.of("yadisk"), "notifications")
                )
            );

            var notification = RecordChange.set(
                "notifications",
                "1",
                fields
            );

            var settings = RecordChange.set(
                "settings",
                "1",
                Cf.map()
                    .plus1("name", DataField.string("cooldown"))
                    .plus1("value", DataField.integer(259200000))
            );

            dataApiManager.applyDelta(db, RevisionCheckMode.PER_RECORD, new Delta(Cf.list(notification, settings)));
            logger.info("Sent promo for uid={}", uid);
            break
        } catch (e) {
            if (iii == 2) {
                logger.debug("Failed to send promo for uid={} : {}", uid, e);
            } else {
                logger.error("Retry send promo for uid={} : {}", uid, e);
            }
        }
    }
}

function sendPromo1(uid) {
    var type = "ufo_notifications_28_02_19_CHEMODAN_58341";
    logger.info("Sending promo notification: uid={}, type={}", uid, type);

    sendPromo(uid, commonParts
        .plus1("statistics_id", DataField.string(type))
        .plus1("link", DataField.string("https://disk.yandex.ru/promo/unlim?from=notification"))
    )
}

function sendPromo2(uid) {
    var type = "ufo_notifications_28_02_19_CHEMODAN_58341";
    logger.info("Sending promo notification: uid={}, type={}", uid, type);

    sendPromo(uid, commonParts
        .plus1("statistics_id", DataField.string(type))
        .plus1("link", DataField.string("https://disk.yandex.com/promo/unlim?from=notification"))
    )
}

function sendPromo3(uid) {
    var type = "ufo_notifications_28_02_19_CHEMODAN_58341";
    logger.info("Sending promo notification: uid={}, type={}", uid, type);

    sendPromo(uid, commonParts
        .plus1("statistics_id", DataField.string(type))
        .plus1("link", DataField.string("https://disk.yandex.ua/promo/unlim?from=notification"))
    )
}

function sendPromo4(uid) {
    var type = "ufo_notifications_28_02_19_CHEMODAN_58341";
    logger.info("Sending promo notification: uid={}, type={}", uid, type);

    sendPromo(uid, commonParts
        .plus1("statistics_id", DataField.string(type))
        .plus1("link", DataField.string("https://disk.yandex.com.tr/promo/unlim?from=notification"))
    )
}

function sendPromoByUid(uid) {
    if (uids_1.contains(uid)) {
        sendPromo1(uid);
    } else if (uids_2.contains(uid)) {
        sendPromo2(uid);
    } else if (uids_3.contains(uid)) {
        sendPromo3(uid);
    } else if (uids_4.contains(uid)) {
        sendPromo4(uid);
    }
}

uids.forEach(function(uid) {
    var finalUid = uid
    executer.submit(new java.lang.Runnable(function() {sendPromoByUid(finalUid);}));
});

executer.shutdown();