importClass(ru.yandex.misc.log.mlf.LoggerFactory);
importPackage(ru.yandex.chemodan.app.dataapi.api.deltas);
importPackage(ru.yandex.chemodan.app.dataapi.api.data.field);
importPackage(ru.yandex.chemodan.app.dataapi.api.user);
importPackage(ru.yandex.chemodan.app.dataapi.api.db.ref);
importPackage(ru.yandex.chemodan.app.dataapi.api.data.filter.condition);

var logger = LoggerFactory.getLogger("promo-notifier");

var start_date_str = "2019-04-19T00:00:00.00+0300"
var end_date_str = "2019-04-27T00:00:00.00+0300"

var executer = java.util.concurrent.Executors.newFixedThreadPool(100, new ru.yandex.misc.thread.factory.ThreadNameIndexThreadFactory("promo-notifier"));

var uids_1 = Cf.list()
var uids_2 = Cf.list()
var uids_3 = Cf.list()
var uids_4 = Cf.list()

//var uids_1 = (new File2("/tmp/notifier_uids_1.txt")).readLines().flatMap(function(x){return Cf.Long.parseSafe(x)}).unique();
//var uids_2 = (new File2("/tmp/notifier_uids_2.txt")).readLines().flatMap(function(x){return Cf.Long.parseSafe(x)}).unique();
//var uids_3 = (new File2("/tmp/notifier_uids_3.txt")).readLines().flatMap(function(x){return Cf.Long.parseSafe(x)}).unique();
//var uids_4 = (new File2("/tmp/notifier_uids_4.txt")).readLines().flatMap(function(x){return Cf.Long.parseSafe(x)}).unique();

//uids_1 = Cf.list(50273844, 582231869)
//uids_2 = Cf.list(50273844, 582231869)
//uids_3 = Cf.list(50273844, 582231869)
//uids_4 = Cf.list(50273844, 582231869)

var uids = uids_1.plus(uids_2).plus(uids_3).plus(uids_4);

var commonParts = Cf.map()
    .plus1("send_date", DataField.timestamp(DateTime.parse(start_date_str).toInstant()))
    .plus1("end_date", DataField.timestamp(DateTime.parse(end_date_str).toInstant()))
    .plus1("link_new_window", DataField.bool(true))
    .plus1("priority", DataField.integer(1))
    .plus1("title_ru", DataField.string("Яндекс.Диск для Windows и macOS"))
    .plus1("title_en", DataField.string("Yandex.Disk for Windows and macOS"))
    .plus1("title_tr", DataField.string("Windows ve macOS için Yandex.Disk"))
    .plus1("title_uk", DataField.string("Яндекс.Діск для Windows i macOS"))
    .plus1("text_ru", DataField.string("Открывайте Диск прямо с рабочего стола компьютера"))
    .plus1("text_en", DataField.string("Open Disk right from your desktop"))
    .plus1("text_tr", DataField.string("Diski masaüstünüzden açın"))
    .plus1("text_uk", DataField.string("Відкривайте Диск прямо з робочого столу комп'ютера"))
    .plus1("link_text_ru", DataField.string("Установить"))
    .plus1("link_text_en", DataField.string("Install"))
    .plus1("link_text_tr", DataField.string("Yüklemek için"))
    .plus1("link_text_uk", DataField.string("Встановити"));

function sendPromo(rawUid, fields) {
    var uid = DataApiUserId.parse("" + rawUid)
    for (var iii = 0; iii < 3; iii += 1) {
        try {
            var db = dataApiManager.getOrCreateDatabase(
                new UserDatabaseSpec(
                    uid,
                    DatabaseRef.cons(Option.of("yadisk"), "notifications")
                )
            );

            var notification = RecordChange.set(
                "notifications",
                "1",
                fields
            );

            var settings = RecordChange.set(
                "settings",
                "1",
                Cf.map()
                    .plus1("name", DataField.string("cooldown"))
                    .plus1("value", DataField.integer(259200000))
            );

            dataApiManager.applyDelta(db, RevisionCheckMode.PER_RECORD, new Delta(Cf.list(notification, settings)));
            logger.info("Sent promo for uid={}", uid);
            break
        } catch (e) {
            if (iii == 2) {
                logger.debug("Failed to send promo for uid={} : {}", uid, e);
            } else {
                logger.error("Retry send promo for uid={} : {}", uid, e);
            }
        }
    }
}

function sendPromo1(uid) {
    var type = "ufo_notifications_19_04_19_CHEMODAN-63060";
    logger.info("Sending promo notification: uid={}, type={}", uid, type);

    sendPromo(uid, commonParts
        .plus1("statistics_id", DataField.string(type))
        .plus1("link", DataField.string("https://disk.yandex.ru/download?src=Yandex.PromoNotification2"))
    )
}

function sendPromoByUid(uid) {
    sendPromo1(uid);
}

uids.forEach(function(uid) {
    var finalUid = uid
    executer.submit(new java.lang.Runnable(function() {sendPromoByUid(finalUid);}));
});

executer.shutdown();