importPackage(ru.yandex.misc.lang)
importClass(ru.yandex.chemodan.app.notifier.notification.NotificationVariant)
importClass(ru.yandex.chemodan.app.notifier.tanker.TankerMessageKey)
importClass(ru.yandex.chemodan.app.notifier.utils.NotifierLanguage)

types = notifierTypesRegistry.getAllTypes().filter(function(t){
    return t.name.startsWith("photo_selection_cool_lenta_") && !t.name.contains("_geo_")
})

suffixes = Cf.list("_geo_small", "_geo_medium", "_geo_long")
withPhoto = Cf.list(
    "photo_selection_cool_lenta_cross_year_common_short",
//           "form": "Посмотрите свои фото с %{date.start:dd.MM.yyyy} по %{date.end:dd.MM.yyyy}"
    "photo_selection_cool_lenta_month_short",
//           "form": "Посмотрите подборку фото за %{month.start:nom} %{date.start:yyyy} года"
    "photo_selection_cool_lenta_month_short_t1_v1",
//           "form": "Посмотрите свои фото за %{month.start:nom} %{date.start:yyyy} года"
    "photo_selection_cool_lenta_one_day_short",
//           "form": "Посмотрите подборку фото за %{date.start:d} %{month.start:gen} %{date.start:yyyy} года"
    "photo_selection_cool_lenta_one_day_short_t1_v1",
//           "form": "Посмотрите фото за %{date.start:d} %{month.start:gen} %{date.start:yyyy} года"
    "photo_selection_cool_lenta_one_day_short_t1_v2",
//           "form": "Ваши фотографии %{date.start:d} %{month.start:gen} %{date.start:yyyy} года"
    "photo_selection_cool_lenta_season_short",
//           "form": "Посмотрите подборку фото за %{season.start:acc} %{date.start:yyyy} года"
    "photo_selection_cool_lenta_week_cross_month_short",
//           "form": "Посмотрите подборку фото с %{date.start:d} %{month.start:gen} по %{date.end:d} %{month.end:gen} %{date.end:yyyy} года"
    "photo_selection_cool_lenta_week_cross_month_short_t2_v1",
//           "form": "Посмотрите свои фото с %{date.start:d} %{month.start:gen} по %{date.end:d} %{month.end:gen} %{date.start:yyyy} года"
    "photo_selection_cool_lenta_week_short",
//           "form": "Посмотрите подборку фото с %{date.start:d} по %{date.end:d} %{month.end:gen} %{date.end:yyyy} года"
    "photo_selection_cool_lenta_week_short_t1_v2",
//           "form": "Посмотрите свои фото с %{date.start:d} по %{date.end:d} %{month.end:gen} %{date.end:yyyy} года"
    "photo_selection_cool_lenta_weekend_short",
//           "form": "Посмотрите подборку фото за выходные с %{date.start:d} %{month.start:gen} %{date.start:yyyy} года"
    "photo_selection_cool_lenta_year_short",
//           "form": "Посмотрите подборку фото за %{date.start:yyyy} год"
    "photo_selection_cool_lenta_year_short_t1_v1",
//           "form": "Посмотрите свои фотографии за %{date.start:yyyy} год"
    "photo_selection_cool_lenta_year_short_t1_v2",
//           "form": "Посмотрите подборку своих фото за %{date.start:yyyy} год"
        "photo_selection_cool_lenta_weekend_cross_month_short_t1_v1",
//           "form": "Фото за выходные %{date.start:d} %{month.start:gen} и %{date.end:d} %{month.end:gen} %{date.start:yyyy} года"

        "photo_selection_cool_lenta_weekend_cross_month_short_t2_v1",
//           "form": "Фотографии выходных %{date.start:d} %{month.start:gen} и %{date.end:d} %{month.end:gen} %{date.start:yyyy} года"

        "photo_selection_cool_lenta_weekend_short_t1_v1",
//           "form": "Фото за выходные %{date.start:d} и %{date.end:d} %{month.start:gen} %{date.start:yyyy} года"

        "photo_selection_cool_lenta_weekend_short_t1_v2"
//           "form": "Фотографии выходных %{date.start:d} и %{date.end:d} %{month.start:gen} %{date.start:yyyy} года"
)

withoutPhoto = Cf.list(
        "photo_selection_cool_lenta_month_short_t2_v1",
//           "form": "Смотрите, какие кадры из %{month.start:gen} %{date.start:yyyy} года"

        "photo_selection_cool_lenta_one_day_short_t2_v1",
//           "form": "Посмотрите, что было %{date.start:d} %{month.start:gen} %{date.start:yyyy} года"

        "photo_selection_cool_lenta_one_day_short_t2_v2",
//           "form": "Смотрите, как вы провели %{date.start:d} %{month.start:gen} %{date.start:yyyy} года"

        "photo_selection_cool_lenta_week_cross_month_short_t1_v1",
//           "form": "Смотрите, что вы сняли с %{date.start:d} %{month.start:gen} по %{date.end:d} %{month.end:gen} %{date.start:yyyy} года"

        "photo_selection_cool_lenta_week_short_t1_v1",
//           "form": "Смотрите, что вы сняли с %{date.start:d} по %{date.end:d} %{month.end:gen} %{date.end:yyyy} года"

        "photo_selection_cool_lenta_week_short_t2_v1",
//           "form": "Ваши снимки с %{date.start:d} по %{date.end:d} %{month.end:gen} %{date.end:yyyy} года"

        "photo_selection_cool_lenta_week_short_t2_v2",
//           "form": "Смотрите события с %{date.start:d} по %{date.end:d} %{month.end:gen} %{date.end:yyyy} года"

        "photo_selection_cool_lenta_weekend_short_t2_v1",
//           "form": "Ваши кадры за выходные %{date.start:d} и %{date.end:d} %{month.start:gen} %{date.start:yyyy} года"

        "photo_selection_cool_lenta_weekend_short_t2_v2",
//           "form": "Что было в выходные %{date.start:d} и %{date.end:d} %{month.start:gen} %{date.start:yyyy} года"

        "photo_selection_cool_lenta_year_short_t2_v1",
//           "form": "Смотрите все ваши снимки за %{date.start:yyyy} год"

        "photo_selection_cool_lenta_year_short_t2_v2"
//           "form": "Что было в %{date.start:yyyy} году — смотрите свои кадры"
)

function getText(key) {
    var locs = localeManager.getAllLocalizations(new TankerMessageKey("notifier-notifications", key));
    if (!locs.isEmpty()) {
        return locs.get(NotifierLanguage.RUSSIAN).message;
    } else {
        return "no localization for " + key;
    }
}

titleSmall = getText("photo_selection_cool_lenta_common_title_geo_small")
titleMedium = getText("photo_selection_cool_lenta_common_title_geo_medium")
titleLong = getText("photo_selection_cool_lenta_common_title_geo_long")

print (titleSmall)
print (titleMedium)
print (titleLong)

print(withoutPhoto.map(function(a){
    return StringUtils.substringBeforeLast(a, "_short")
}))

for (var i = 0; i < types.size(); i++) {
    type = types.get(i);
    for (var j = 0; j < suffixes.size(); j++) {
        suffix = suffixes.get(j)

        print("-------------------------------------------------")
        print(StringUtils.substringAfter(type.name, "photo_selection_cool_lenta_") + "   /   " + suffix)
        print("-------------------------------------------------")

        variants = Cf.list()
        if (!type.name.contains("cross_year")) {
            var k = 0;
            variants = withoutPhoto.plus(withPhoto).filter(function(a) {
                    return type.name.startsWith(StringUtils.substringBeforeLast(a, "_short"))
            }).map(function(a) {
                print (getText("photo_selection_cool_lenta_common_title_geo_long"))
                print (getText(a))
                print (" ")

                    return new NotificationVariant(
                        "n1_long_" + k++, 0.0, 0.0,
                        Option.empty(), Option.empty(),

                        Option.of("photo_selection_cool_lenta_common_title_geo_long"),
                        Option.of(a),

                        Option.empty(), Option.empty()
            )});

            if (suffix.contains("_geo_small") || suffix.contains("_geo_medium")) {
                variants = variants.plus(withoutPhoto.filter(function(a) {
                         return type.name.startsWith(StringUtils.substringBeforeLast(a, "_short"))
                 }).map(function(a) {
                     print (getText("photo_selection_cool_lenta_common_title_geo_medium"))
                     print (getText(a))
                     print (" ")
                         return new NotificationVariant(
                             "n1_medium_" + k++, 0.0, 0.0,
                             Option.empty(), Option.empty(),

                             Option.of("photo_selection_cool_lenta_common_title_geo_medium"),
                             Option.of(a),

                             Option.empty(), Option.empty()
                 )}));
            }

            if (suffix.contains("_geo_small")) {
                variants = variants.plus(withoutPhoto.filter(function(a) {
                         return type.name.startsWith(StringUtils.substringBeforeLast(a, "_short"))
                 }).map(function(a) {
                     print (getText("photo_selection_cool_lenta_common_title_geo_small"))
                     print (getText(a))
                     print (" ")

                         return new NotificationVariant(
                             "n1_small_"  + k++, 0.0, 0.0,
                             Option.empty(), Option.empty(),

                             Option.of("photo_selection_cool_lenta_common_title_geo_small"),
                             Option.of(a),

                             Option.empty(), Option.empty()
                 )}));
            }
        }

        print (getText("photo_selection_cool_lenta_common_title_geo_long"))
         print (getText(type.tankerShortMessageKey))
         print (" ")

        newType = new ru.yandex.chemodan.app.notifier.notification.NotificationType(
            Option.empty(), type.groupId,
            type.name + suffix,
            Option.empty(), type.icon, type.tankerMessageKey,

            "photo_selection_cool_lenta_common_title_geo_long",

            type.tankerShortMessageKey, type.description, type.counterConfiguration, type.defaultMetadata, type. defaultDelay,
            variants
        )

//        print(newType)
//        print(variants.mkString("\n"))
        //notifierTypesRegistry.saveType(newType)
    }
}
