importClass(ru.yandex.misc.log.mlf.LoggerFactory);
importPackage(ru.yandex.chemodan.app.dataapi.api.data.record)
importPackage(ru.yandex.chemodan.app.dataapi.api.deltas);
importPackage(ru.yandex.chemodan.app.dataapi.api.data.field);
importPackage(ru.yandex.chemodan.app.dataapi.api.user);
importPackage(ru.yandex.chemodan.app.dataapi.api.db.ref);
importPackage(ru.yandex.chemodan.app.dataapi.api.data.filter.condition);

var logger = LoggerFactory.getLogger("promo-notifier");

var executer = java.util.concurrent.Executors.newFixedThreadPool(100, new ru.yandex.misc.thread.factory.ThreadNameIndexThreadFactory("promo-notifier"));

var uids = (new File2("/tmp/notifier_desktop.txt")).readLines().flatMap(function(x){return Cf.Long.parseSafe(x)})

// При тестировании на Яндексоидах надо менять config_v3 на config_v3_staff

function deletePromo(uidRaw) {
    var uid = DataApiUserId.parse("" + uidRaw)
    try {
        for (var i = 0; i < 3; i++) {
            var db = dataApiManager.getOrCreateDatabase(
                new UserDatabaseSpec(
                    uid,
                    DatabaseRef.cons(Option.of("yadisk"), "common")
                )
            );

            var collectionId = 'config_v3';
            var recordId = 'windows'
            var fieldId = 'News'

            // Если объект уже есть - надо удалить поле
            if (dataApiManager.getRecord(uid, db.dbRef().consColRef(collectionId).consRecordRef(recordId)).isPresent()) {
                var fieldChange = FieldChange.delete(fieldId);
                var recordChange = RecordChange.update(collectionId, recordId, fieldChange);

                dataApiManager.applyDelta(db, RevisionCheckMode.PER_RECORD, new Delta(Cf.list(recordChange)));
                logger.error("Deleted notification for uid={}", uid);

                return
            } else {
                logger.error("Nothing to delete for uid={}", uid);
            }
        }
    } catch (e) {
        logger.error("Failed to delete notification for uid={}", uid);
    }
}

uids.forEach(function(uid) {
    var finalUid = uid
    executer.submit(new java.lang.Runnable(function() {
        deletePromo(finalUid);
    }));
});

executer.shutdown();