importPackage(ru.yandex.inside.passport);
importPackage(ru.yandex.chemodan.util.json);
importPackage(ru.yandex.chemodan.xiva);
importPackage(ru.yandex.chemodan.app.dataapi.core.xiva);
importPackage(ru.yandex.chemodan.app.dataapi.api.user);
importPackage(ru.yandex.chemodan.app.notifier.settings);
importPackage(ru.yandex.chemodan.app.notifier.push.body);
importPackage(ru.yandex.chemodan.app.notifier.notification);
importPackage(ru.yandex.chemodan.app.notifier.metadata);
importPackage(org.joda.time);
importPackage(ru.yandex.chemodan.util);
importPackage(ru.yandex.chemodan.app.notifier.tanker);
importClass(ru.yandex.misc.log.mlf.LoggerFactory);
importPackage(ru.yandex.inside.yt.kosher.cypress);
importPackage(ru.yandex.inside.yt.kosher.tables);
importPackage(java.nio.file);
importPackage(java.nio.charset);
importPackage(ru.yandex.chemodan.util.yt);
importPackage(ru.yandex.inside.yt.kosher.impl);
importPackage(java.util.concurrent);

var uidsToSend = Cf.x([480353447]);
var betaVersion = '4.56';
var title = 'Заголовок в бету';
var text = 'Текст в бету'
var ytPath = '//home/disk-dev/messiahlap/beta_pushes/uids';
var step = 100;
var size = 1;
var offset = 0;
var tokenPath = '/home/messiahlap/yql.token'

new Array('', '0', '0V', '1B', '1I', '1V', '2', '2V', '2B', '3', '3B', '3I', '3V').forEach(function(suffix) {
    this['f' + suffix] = function(func) {
        return new (Java.extend(ru.yandex.bolts['function']['Function' + suffix], {
            apply: function() {
                return func.apply(this, arguments);
            }
        }))()
    };
});

var logger = LoggerFactory.getLogger('send_pushes_to_beta');


var sendPushToUid = function(uid) {
	logger.info('Start processing uid={}', uid);
	var puid = PassportUid.cons(uid);
	var subscriptions = notifierXivaClient.list(puid, 'disk-notifier').filter(function(sub) {
		return sub.getPlatform().map(function(platform) {
			return 'gcm' === platform || 'hms' === platform
		}).getOrElse(false);
	}).filter(function(sub) {
		return sub.getFilter().map(function(filter) {
			var node = JsonNodeUtils.getNode(filter);
            var vars = node.get('vars')
            if (!vars) {
                return false;
            }
            var versionNode = vars.get('Version')
			if (!versionNode) {
				return false;
			}
			var hasTagsNode = versionNode.get('$has_tags');
			return betaVersion === hasTagsNode.get(0).textValue();
		}).getOrElse(false);
	});
	if (subscriptions.isEmpty()) {
		logger.info('No beta subscriptions for uid={}', uid);
		return;
	}
	var result = Cf.arrayList();
    subscriptions.forEach(function(subscription) {
	        var event = new XivaEvent.Builder()
	                                     .withRecipient(DataApiXivaUtils.toXivaRecipient(new DataApiPassportUserId(puid)))
	                                     .withTags(Cf.list('android'))
	                                     .withEvent('notification_mobile_v2')
	                                     .withSubscriptions(XivaSubscriptionFilter.builder().subscriptionIds(Cf.list(subscription.getId())).build())
	                                    .withBody(createBody(puid))
	                                    .build();
	       result.add(notifierXivaClient.send(event));
	       logger.info('Sent uid={} subscription={}', uid, subscription);
       }
	)
	logger.info('The push has been sent for uid={}', uid);
	return result;
}

var createBody = function(uid) {
	var template = new NotificationTemplate("beta_push", "beta", "beta", "disk", "default",
                     new TankerMessageKey("", ""),
                     new TankerMessageKey("", ""),
                     new TankerMessageKey("", ""),
                     MetadataWrapper.createEmpty(), Duration.ZERO,
                     Option.empty());
	return new NotificationMobilePushBody(
                    GlobalSubscriptionChannelGroup.MOBILE_V2, uid, template,
                    Option.empty(), title, text,
                    "",
                    Option.empty(),
                    Cf.map(XivaPushService.GCM, AppVersionRange.fromIntervalString(betaVersion + '-'))
            );
}


var sendToKnownSet = function() {
	logger.info('Start send pushes to beta by set beta_version={}', betaVersion);
	uidsToSend.forEach(function(uid) {
	   sendPushToUid(uid);
    });
}

var sendByYt = function() {
	logger.info('Start send pushes to beta by YT beta_version={}', betaVersion);
	var executer = java.util.concurrent.Executors.newFixedThreadPool(10, new ru.yandex.misc.thread.factory.ThreadNameIndexThreadFactory("send_pushes_to_beta"));
	var ytHelper = getYtHelper();
	for (var i = offset; i < size; i += step) {
	    var path = YPath.simple(ytPath).withRange(i, Math.min(i + step, size))

        ytHelper.tables().read(path, YTableEntryTypes.JACKSON, f1V(function (node) {
            var accountId = node.get("uid");
            if (!accountId) {
                return;
            }
            var finalUid = Cf.Long.parse(accountId.asText());

            executer.submit(new java.lang.Runnable(function() {
                sendPushToUid(finalUid)
            }))
        }));
    }
    executer.shutdown();
}

var getYtHelper = function() {
	var token = new java.lang.String(Files.readAllBytes(Paths.get(tokenPath)), StandardCharsets.UTF_8).trim();
	var yt = YtUtils.http('hahn.yt.yandex.net', token);
	return yt;
}

//sendByYt();
//sendToKnownSet();


