importClass(ru.yandex.misc.log.mlf.LoggerFactory);
importPackage(ru.yandex.chemodan.app.dataapi.api.deltas);
importPackage(ru.yandex.chemodan.app.dataapi.api.data.field);
importPackage(ru.yandex.chemodan.app.dataapi.api.user);
importPackage(ru.yandex.chemodan.app.dataapi.api.db.ref);
importPackage(ru.yandex.chemodan.app.dataapi.api.data.filter.condition);

var logger = LoggerFactory.getLogger("promo-notifier");

var start_date_str = "2019-02-07T00:00:00.00+0300"
var end_date_str = "2019-02-14T00:00:00.00+0300"

var executer = java.util.concurrent.Executors.newFixedThreadPool(100, new ru.yandex.misc.thread.factory.ThreadNameIndexThreadFactory("promo-notifier"));

var uids_1 = (new File2("/tmp/notifier_uids_1.txt")).readLines().flatMap(function(x){return Cf.Long.parseSafe(x)}).unique();
var uids_2 = (new File2("/tmp/notifier_uids_2.txt")).readLines().flatMap(function(x){return Cf.Long.parseSafe(x)}).unique();
var uids_3 = (new File2("/tmp/notifier_uids_3.txt")).readLines().flatMap(function(x){return Cf.Long.parseSafe(x)}).unique();
var uids_4 = (new File2("/tmp/notifier_uids_4.txt")).readLines().flatMap(function(x){return Cf.Long.parseSafe(x)}).unique();

uids = uids_1.plus(uids_2).plus(uids_3).plus(uids_4)

var commonParts = Cf.map()
    .plus1("send_date", DataField.timestamp(DateTime.parse(start_date_str).toInstant()))
    .plus1("end_date", DataField.timestamp(DateTime.parse(end_date_str).toInstant()))
    .plus1("link_new_window", DataField.bool(true))
    .plus1("priority", DataField.integer(1))
    .plus1("link_text_en", DataField.string("Ответить"))
    .plus1("link_text_ru", DataField.string("Ответить"))
    .plus1("link_text_tr", DataField.string("Ответить"))
    .plus1("link_text_uk", DataField.string("Ответить"))
    .plus1("text_en", DataField.string("Нам важно ваше мнение. Это займет меньше минуты."))
    .plus1("text_ru", DataField.string("Нам важно ваше мнение. Это займет меньше минуты."))
    .plus1("text_tr", DataField.string("Нам важно ваше мнение. Это займет меньше минуты."))
    .plus1("text_uk", DataField.string("Нам важно ваше мнение. Это займет меньше минуты."))
    .plus1("title_en", DataField.string("Нравится ли вам Яндекс.Диск?"))
    .plus1("title_ru", DataField.string("Нравится ли вам Яндекс.Диск?"))
    .plus1("title_tr", DataField.string("Нравится ли вам Яндекс.Диск?"))
    .plus1("title_uk", DataField.string("Нравится ли вам Яндекс.Диск?"));

function sendPromo(rawUid, fields) {
    var uid = DataApiUserId.parse("" + rawUid)
    for (var iii = 0; iii < 3; iii += 1) {
        try {
            var db = dataApiManager.getOrCreateDatabase(
                new UserDatabaseSpec(
                    uid,
                    DatabaseRef.cons(Option.of("yadisk"), "notifications")
                )
            );

            var notification = RecordChange.set(
                "notifications",
                "1",
                fields
            );

            var settings = RecordChange.set(
                "settings",
                "1",
                Cf.map()
                    .plus1("name", DataField.string("cooldown"))
                    .plus1("value", DataField.integer(259200000))
            );

            dataApiManager.applyDelta(db, RevisionCheckMode.PER_RECORD, new Delta(Cf.list(notification, settings)));
            logger.info("Sent promo for uid={}", uid);
            break
        } catch (e) {
            if (iii == 2) {
                logger.debug("Failed to send promo for uid={} : {}", uid, e);
            } else {
                logger.error("Retry send promo for uid={} : {}", uid, e);
            }
        }
    }
}

function sendPromo1(uid) {
    var type = "ufo_notifications_07_02_19_NPS_group_1";
    logger.info("Sending promo notification: uid={}, type={}", uid, type);

    sendPromo(uid, commonParts
        .plus1("statistics_id", DataField.string(type))
        .plus1("link", DataField.string("https://yandex.ru/poll/HYTJxBq58sMrHkVn3y62ho"))
    )
}

function sendPromo2(uid) {
    var type = "ufo_notifications_07_02_19_NPS_group_2";
    logger.info("Sending promo notification: uid={}, type={}", uid, type);

    sendPromo(uid, commonParts
        .plus1("statistics_id", DataField.string(type))
        .plus1("link", DataField.string("https://yandex.ru/poll/7a1ADtJB3x7Egj9CqsdRaJ"))
    )
}

function sendPromo3(uid) {
    var type = "ufo_notifications_07_02_19_NPS_group_3";
    logger.info("Sending promo notification: uid={}, type={}", uid, type);

    sendPromo(uid, commonParts
        .plus1("statistics_id", DataField.string(type))
        .plus1("link", DataField.string("https://yandex.ru/poll/2hMLLeKSqmFXW7BmNRLNUP"))
    )
}

function sendPromo4(uid) {
    var type = "ufo_notifications_07_02_19_NPS_group_4";
    logger.info("Sending promo notification: uid={}, type={}", uid, type);

    sendPromo(uid, commonParts
        .plus1("statistics_id", DataField.string(type))
        .plus1("link", DataField.string("https://yandex.ru/poll/Bjz6fTtbHC4G5MzPDtkRZq"))
    )
}

function sendPromoByUid(uid) {
    if (uids_1.contains(uid)) {
        sendPromo1(uid);
    } else if (uids_2.contains(uid)) {
        sendPromo2(uid);
    } else if (uids_3.contains(uid)) {
        sendPromo3(uid);
    } else if (uids_4.contains(uid)) {
        sendPromo4(uid);
    }
}

uids.forEach(function(uid) {
    var finalUid = uid
    executer.submit(new java.lang.Runnable(function() {sendPromoByUid(finalUid);}));
});

executer.shutdown();