importClass(ru.yandex.misc.log.mlf.LoggerFactory);
importPackage(ru.yandex.chemodan.app.dataapi.api.data.record)
importPackage(ru.yandex.chemodan.app.dataapi.api.deltas);
importPackage(ru.yandex.chemodan.app.dataapi.api.data.field);
importPackage(ru.yandex.chemodan.app.dataapi.api.user);
importPackage(ru.yandex.chemodan.app.dataapi.api.db.ref);
importPackage(ru.yandex.chemodan.app.dataapi.api.data.filter.condition);

var logger = LoggerFactory.getLogger("promo-notifier");

var executer = java.util.concurrent.Executors.newFixedThreadPool(100, new ru.yandex.misc.thread.factory.ThreadNameIndexThreadFactory("promo-notifier"));

var uids = (new File2("/tmp/notifier_desktop.txt")).readLines().flatMap(function(x){return Cf.Long.parseSafe(x)})

var news_json = "{\t\"news_id\": 2,\t\"type\": \"classic\",\t\"min_target_version\": \"3.0.9.2535\",\t\"max_target_version\": \"3.2.0\",\t\"expiration_time\": \"20190213T235959\",\t\"presentation_duration\": 0,\t\"ru\": {\t\t\"balloon_block\": {\t\t\t\"header\": \"Нравится ли вам Яндекс.Диск?\",\t\t\t\"body\": \"Нам важно ваше мнение. Это займет меньше минуты.\",\t\t\t\"url\": \"https://yandex.ru/poll/VvYynpmmW5Vz7V3Cd2VcgV\",\t\t\t\"icon\": {\t\t\t\t\"type\": \"disk\",\t\t\t\t\"url_sd\": \"\",\t\t\t\t\"url\": \"\"\t\t\t},\t\t\t\"buttons\": [{\t\t\t\t\"title\": \"Не сейчас\",\t\t\t\t\"url\": \"\"\t\t\t}, {\t\t\t\t\"title\": \"Ответить\",\t\t\t\t\"url\": \"https://yandex.ru/poll/VvYynpmmW5Vz7V3Cd2VcgV\"\t\t\t}]\t\t},\t\t\"advanced_balloon_block\": {},\t\t\"menu_block\": {\t\t\t\"header\": \"Нравится ли вам Яндекс.Диск?\",\t\t\t\"body\": \"Нам важно ваше мнение. Это займет меньше минуты.\",\t\t\t\"url\": \"https://yandex.ru/poll/VvYynpmmW5Vz7V3Cd2VcgV\",\t\t\t\"icon\": {\t\t\t\t\"type\": \"disk\",\t\t\t\t\"url_sd\": \"\",\t\t\t\t\"url\": \"\"\t\t\t},\t\t\t\"buttons\": [{\t\t\t\t\"title\": \"Ответить\",\t\t\t\t\"url\": \"https://yandex.ru/poll/VvYynpmmW5Vz7V3Cd2VcgV\"\t\t\t}, {\t\t\t\t\"title\": \"Закрыть\",\t\t\t\t\"url\": \"\"\t\t\t}]\t\t}\t},\t\"en\": {},\t\"uk\": {},\t\"tr\": {}}"

// При тестировании на Яндексоидах надо менять config_v3 на config_v3_staff

function sendPromo(uidRaw) {
    var uid = DataApiUserId.parse("" + uidRaw)

    for (var iii = 0; iii < 3; iii += 1) {
        try {
            var db = dataApiManager.getOrCreateDatabase(
                new UserDatabaseSpec(
                    uid,
                    DatabaseRef.cons(Option.of("yadisk"), "common")
                )
            );

            var collectionId = 'config_v3';
            var recordId = 'windows'
            var fieldId = 'News'

            var recordChange = null
            // Если объект уже есть - надо обновить поле
            // Если нет - создать новый объект
            recordO = dataApiManager.getRecord(uid, db.dbRef().consColRef(collectionId).consRecordRef(recordId))
            if (recordO.isPresent()) {
                if (recordO.get().getData().containsKeyTs(fieldId)) {
                    logger.info("Skip promo for uid={}", uid);
                    break
                }

                var fieldChange = FieldChange.put(fieldId, DataField.string(news_json));
                recordChange = RecordChange.update(collectionId, recordId, fieldChange);
            } else {
                recordChange = new SimpleDataRecord(collectionId, recordId, NamedDataField.string(fieldId, news_json)).toInsertChange();
            }

            dataApiManager.applyDelta(db, RevisionCheckMode.PER_RECORD, new Delta(Cf.list(recordChange)));
            logger.info("Sent promo for uid={}", uid);
            break
        } catch (e) {
            if (iii == 2) {
                logger.debug("Failed to send promo for uid={} : {}", uid, e);
            } else {
                logger.error("Retry send promo for uid={} : {}", uid, e);
            }
        }
    }
}

uids.forEach(function(uid) {
    var finalUid = uid
    executer.submit(new java.lang.Runnable(function() {sendPromo(finalUid);}));
});

executer.shutdown();