#!/usr/bin/python
# -*- coding: utf-8 -*-

import os
import sys

from build_package import build_package

#todo: add components

complex_components = {
    "djfs": [
        "djfs/api",
        "djfs/worker",
        "djfs/albums"
    ],
    "ps-billing": [
            "ps-billing/web",
            "ps-billing/worker"
        ],
    "dataapi": [
        "dataapi/backend",
        "dataapi/worker",
    ],
    "axis": [
        "axis/factapi",
        "axis/factprocessor"
    ],
    "lenta": [
        "lenta/backend",
        "lenta/worker"
    ],
    "smartcache": [
        "smartcache/client",
        "smartcache/worker"
    ],
    "orchestrator": [
        "orchestrator/api",
        "orchestrator/worker"
    ],
    "comments": ["commentaries"],
    "datasync-admin": ["dataapi/admin"],
    "djfs-api": ["djfs/api"],
    "djfs-worker": ["djfs/worker"],
    "djfs-albums": ["djfs/albums"],
    "event-loader": ["eventloader"],
    "uploader-balancer": ["balancer"],
    "ps-billing-web":["ps-billing/web"],
    "ps-billing-worker":["ps-billing/worker"]
}

debian_components = [
    "dataapi", "uploader", "log-reader"
]


if __name__ == "__main__":
    # chdir to arcadia/disk
    os.chdir(os.path.abspath(os.path.join(os.path.abspath(sys.argv[0]), os.pardir, os.pardir, os.pardir)))

    if len(sys.argv) < 2:
        print "usage build_component.py {component}"
        sys.exit(1)

    component = sys.argv[1]
    if component not in complex_components and not os.path.exists(component):
        print "Unknown component " + component
        sys.exit(1)

    print "Going to build packages from: [" + ", ".join(complex_components.get(component, [component])) + "]"

    for base_path in complex_components.get(component, [component]):
        print "============================================="
        print "Building " + base_path
        print "============================================="

        build_package(base_path, sys.argv[2:])
