#!/usr/bin/python
# -*- coding: utf-8 -*-

import sys, os, stat, shutil, errno
import json


def mkdir_p(path):
    try:
        os.makedirs(path)
    except OSError as exc:  # Python >2.5
        if exc.errno == errno.EEXIST and os.path.isdir(path):
            pass
        else:
            raise


def copy_safe(src, dst):
    if os.path.exists(src):
        dst_parent = os.path.abspath(os.path.join(dst, os.pardir))
        mkdir_p(dst_parent)

        try:
            if os.path.isfile(src):
                shutil.copy(src, dst)
            else:
                shutil.copytree(src, dst)
        except OSError as exc:  # Python >2.5
            if exc.errno == errno.EEXIST:
                pass
            else:
                raise


def rm_safe(path):
    if os.path.exists(path):
        if os.path.isfile(path):
            os.remove(path)
        else:
            shutil.rmtree(path)


def chmod_x(path):
    os.chmod(path, os.stat(path).st_mode | stat.S_IEXEC)


def ya_cmd_line(args):
    passed_cmd_line = " ".join(args[1:])
    cmd_line = "../ya " + args[0] + " "
    log_line = "../ya " + " ".join(args)

    cmd_line += " " + passed_cmd_line

    return cmd_line, log_line


def ya(args):
    cmd_line, log_line = ya_cmd_line(args)

    print "execute " + log_line
    if os.system(cmd_line):
        sys.exit(1)


def qloud_deploy(environment, application):
    cmd_line = "./admin/qloud-deploy/qloud-deploy qloud deploy" + \
               " --no-prompt" + \
               " --image=latest" + \
               " " + environment + \
               " --application=" + application

    print "execute " + cmd_line
    if os.system(cmd_line):
        sys.exit(1)


def get_secret_value(secret_id, field):
    cmd_line, log_line = ya_cmd_line(["vault", "get", "version", secret_id, "-j"])

    print "execute " + log_line
    output = os.popen(cmd_line).read()
    try:
        return json.loads(output)['value'][field]
    except Exception:
        print 'Failed to get secret'
        return None


def ya_package(args, package_json):
    ya(['package', '--checkout', '--fixme-CHEMODAN-80080'] + args + [package_json])
