#!/usr/bin/python
# -*- coding: utf-8 -*-

import sys
from configurator import Configurator


def gen_monrun_conf(base_path, output_path):
    conf = Configurator(base_path)

    out = open(output_path, "w")

    app = conf.eval_str("[${app}]")
    out.write(app)
    out.write("\nexecution_interval=60\n")
    out.write(conf.eval_str("command=/usr/bin/jhttp.sh --server localhost --port ${${app-prefix}.admin.http.port} --url /ping"))

    out.close()


if __name__ == "__main__":
    if len(sys.argv) < 2:
        print "usage: " + sys.argv[0] + " {base_path} {output_path}"
        exit(1)

    base_path = sys.argv[1]
    output_path = sys.argv[2]

    gen_monrun_conf(base_path, output_path)
