#!/usr/bin/python
# -*- coding: utf-8 -*-

import sys
from configurator import Configurator


def gen_nginx_conf(base_path, output_dir):
    conf = Configurator(base_path)

    conf.eval_folder("devel/etc/nginx/sites-enabled", output_dir)

if __name__ == "__main__":
    if len(sys.argv) < 3:
        print "usage: " + sys.argv[0] + " {base_path} {output_dir}"
        exit(1)

    base_path = sys.argv[1]
    output_dir = sys.argv[2]

    gen_nginx_conf(base_path, output_dir)
