#!/usr/bin/python
# -*- coding: utf-8 -*-

import sys
import os
import json
from configurator import Configurator


def gen_package_json(base_path, output_path, version_suffix=''):
    conf = Configurator(base_path)

    package_info = conf.load_json("support/package.json", base_path + "/package.json")

    if sys.platform == 'darwin':
        _rm_patterns(package_info, ['*.so'])

    package_info['meta']['version'] = package_info['meta']['version'] + (version_suffix if version_suffix else '')

    out = open(output_path, "w")
    out.write(json.dumps(package_info, indent=4, separators=(',', ': ')))
    out.close()


def _rm_patterns(package_info, patterns):
    for data in package_info.get('data', []):
        source = data.get('source', {})
        if 'files' not in source:
            continue

        orig_files = source['files']
        source['files'] = [f for f in source['files'] if f.lower() not in patterns]
        if orig_files != source['files']:
            diff = set(orig_files) - set(source['files'])
            print 'Dropped %s for path %s from package.json' % (','.join(diff), source.get('path', ''))


if __name__ == "__main__":
    base_path = sys.argv[1]
    output_path = base_path + "/package.json"
    if len(sys.argv) > 2:
        output_path = sys.argv[2]

    gen_package_json(base_path, output_path)
