#!/usr/bin/python
# -*- coding: utf-8 -*-

from common import *


def ex(command):
    return os.popen(command).read()


def gen_version_properties(output_path):
    with open(output_path, "w") as f:

        svn_url = "unknown"
        svn_rev = "unknown"

        svn_info = ex(ya_cmd_line(["svn", "info"])[0])
        for line in svn_info.split("\n"):
            line = line.strip()

            if line.startswith("URL:"):
                svn_url = line[len("URL:") :]

            elif line.startswith("Last Changed Rev: "):
                svn_rev = line[len("Last Changed Rev: ") :]

        f.write("project.version: " + ex("devel/deb_version.sh"))

        f.write("project.svn.rev: %s\n" % svn_rev)
        f.write("project.svn.url: %s\n" % svn_url)

        f.write("build.date: " + ex("LC_ALL=en_US.UTF-8 date"))
        f.write("build.host: " + ex("hostname -f"))
        f.write("build.user: " + ex("whoami"))


if __name__ == "__main__":
    if len(sys.argv) < 2:
        print "usage: " + sys.argv[0] + " {output_path}"
        exit(1)

    output_path = sys.argv[1]

    gen_version_properties(output_path)
