#!/usr/bin/python
# -*- coding: utf-8 -*-

import sys, json, os
from configurator import Configurator
from gen_ubic import get_ubic_json_config


if __name__ == "__main__":
    base_path = sys.argv[1]

    # chdir to arcadia/disk
    os.chdir(os.path.abspath(os.path.join(os.path.abspath(sys.argv[0]), os.pardir, os.pardir, os.pardir)))

    conf = Configurator(base_path)
    ubicConfig = get_ubic_json_config(conf)

    build_out_dir = os.path.abspath(base_path + "/disk-" + conf.get_app())

    ubicConfig['java_args']['default']['library'] = '-Djava.library.path=' + build_out_dir
    ubicConfig['java_args']['default']['jna'] = '-Djava.library.path=' + build_out_dir

    command = '../ya tool java '

    classpath = []
    for f in os.listdir(build_out_dir):
        path = os.path.join(build_out_dir, f)
        # find all files, ending with '-default.properties'
        if os.path.isfile(path) and f.find('.jar') >= 0:
            classpath.append(path)

    command += "-classpath " + ":".join(classpath) + " "

    javaArgs = ubicConfig['java_args']['default']
    javaArgs.update(ubicConfig['java_args']['development'])

    command += " ".join(javaArgs.values()) + " "

    command += ubicConfig['main_class']

    print command
    if os.system(command):
        sys.exit(1)
