#!/bin/bash

set -e

ec() {
    echo "$@"
    "$@"
}

if [ -z $1 ]; then
    echo "Select branch to build!"
    exit 1
fi

branch=$1
shift

if [ $branch = "master" ]; then
    if [ -z $1 ]; then
        echo "Can't build master without component!"
        exit 1
    fi
    component=$1
    shift
fi

if [[ "${SSH_PRIVATE_KEY}" ]]; then
    mkdir -p ~/.ssh
#    echo "-----BEGIN OPENSSH PRIVATE KEY-----" >~/.ssh/id_rsa
#    echo $SSH_PRIVATE_KEY | tr ' ' '\n' | fgrep -v -e "----" | fgrep -v "OPENSSH" | fgrep -v "PRIVATE" >>~/.ssh/id_rsa
#    echo "-----END OPENSSH PRIVATE KEY-----" >>~/.ssh/id_rsa
#    echo "" >>~/.ssh/id_rsa

    echo "$SSH_PRIVATE_KEY" > ~/.ssh/id_rsa
    chmod 600 ~/.ssh/id_rsa

#    echo "cat ~/.ssh/id_rsa"
#    cat ~/.ssh/id_rsa
#    echo ""
#    echo "cat /home/sandbox/.ssh/id_rsa"
#    cat /home/sandbox/.ssh/id_rsa

    echo "ssh-keygen -y -f ~/.ssh/id_rsa"
    ssh-keygen -y -f ~/.ssh/id_rsa

    echo "cat ~/.ssh/id_rsa | ssh-add -"
    cat ~/.ssh/id_rsa | ssh-add -

    echo "stored ssh key"
    echo "testing ssh connection way 1"
    ssh -v robot-disk-j-build@yandex-disk-common.dupload.dist.yandex.ru exit
    echo "$?"

    echo "testing ssh connection way 2"
    ssh -v -i ~/.ssh/id_rsa robot-disk-j-build@yandex-disk-common.dupload.dist.yandex.ru exit
    echo "$?"
fi

if [[ "${GPG_PUBLIC_KEY}" ]]; then
    mkdir -p /tmp/gpg
    echo "-----BEGIN PGP PUBLIC KEY BLOCK-----" > /tmp/gpg/public.asc
    echo "Version: GnuPG v1.4.11 (GNU/Linux)" >> /tmp/gpg/public.asc
    echo "" >> /tmp/gpg/public.asc
    echo $GPG_PUBLIC_KEY >>/tmp/gpg/public.asc
    echo "-----END PGP PUBLIC KEY BLOCK-----" >> /tmp/gpg/public.asc

    gpg --import /tmp/gpg/public.asc
    rm /tmp/gpg/public.asc
    echo "imported gpg public key"
fi

if [[ "${GPG_SECRET_KEY}" ]]; then
    mkdir -p /tmp/gpg
    echo "-----BEGIN PGP PRIVATE KEY BLOCK-----" > /tmp/gpg/secret.asc
    echo "Version: GnuPG v1.4.11 (GNU/Linux)" >> /tmp/gpg/secret.asc
    echo "" >> /tmp/gpg/secret.asc
    echo $GPG_SECRET_KEY >>/tmp/gpg/secret.asc
    echo "-----END PGP PRIVATE KEY BLOCK-----" >> /tmp/gpg/secret.asc

    gpg --import /tmp/gpg/secret.asc
    rm /tmp/gpg/secret.asc
    echo "imported gpg secret key"

    echo "package config;"                                                  > ~/.dupload.conf
    echo ""                                                                 >> ~/.dupload.conf
    echo "\$default_host = \"common\";"                                     >> ~/.dupload.conf
    echo ""                                                                 >> ~/.dupload.conf
    echo "\$cfg{'yandex-disk-common'} = {"                                  >> ~/.dupload.conf
    echo "    fqdn => \"yandex-disk-common.dupload.dist.yandex.ru\","       >> ~/.dupload.conf
    echo "    method => \"scpb\","                                          >> ~/.dupload.conf
    echo "    incoming => \"/repo/yandex-disk-common/mini-dinstall/incoming/\"," >> ~/.dupload.conf
    echo "    dinstall_runs => 0,"                                          >> ~/.dupload.conf
    echo "    login => 'robot-disk-j-build',"                               >> ~/.dupload.conf
    echo "};"                                                               >> ~/.dupload.conf

    echo "cat ~/.dupload.conf"
    cat ~/.dupload.conf
fi

if [ -z $component ]; then
    if [[ $(echo $branch | grep ^release[-_].*[-_][^-_]*$) ]]; then
        component=$(echo $branch | sed 's/^release[-_]\(.*\)[-_][^-_]*$/\1/')
    else
        echo "branch name must be release_{component}_{version}"
        exit 1
    fi
fi

ec svn export svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/ya

if [ $branch = "master" ]; then
    ec ./ya clone
else
    ec ./ya clone --branch /arc/branches/disk/$branch
fi

ec cd arcadia
ec ./ya svn up disk
ec ./ya svn up iceberg

ec cd disk
ec devel/inc_changelog_version.sh

version=$(devel/deb_version.sh)
echo "##teamcity[buildNumber '$version-']"

ec ./devel/package/build_component.py $component "$@"
