expirationDays = 21;
REMOVING_UIDS_BATCH_SIZE = 1;
REMOVING_REPETETIONS = 150;
SLEEP_MS = 2000;

expirationInstant = Instant.now().minus(Duration.standardDays(expirationDays));
tracked = Cf.list();
cleanupUids = 0;
removedSnapshotsCount = 0;

startTs = Instant.now();

function getLastRetrievedRevision(uid, handle) {
    currentRetrievedRevisionO = lastRetrievedRevisionTrackerMdao.getCurrentRevision(uid, handle);
    if (currentRetrievedRevisionO.isPresent()) {
        return currentRetrievedRevisionO;
    }
    databaseO = dataApiStorageManager.getDatabaseByHandleO(uid, handle);
    if (databaseO.isEmpty()) {
        return Option.empty();
    }
    lastRetrievedRevisionTrackerMdao.updateRevision(uid, handle, databaseO.get().rev);
    return Option.of(databaseO.get().rev);
}

function removeExpiredDeltas(trackedDelta) {
    id = trackedDelta.deltaId;
    dataApiStorageManager.removeOldDeltas(id.uid, id.handle, trackedDelta.revision);
    revisionToSetO = getLastRetrievedRevision(id.uid, id.handle);
    if (revisionToSetO.isEmpty()) {
        deltaAccessTimeMdao.removeTracking(id.uid, id.handle);
        return 0;
    }
    if (revisionToSetO.get().longValue() == trackedDelta.revision) {
        dataApiStorageManager.removeDatabaseByHandle(id.uid, id.handle);
        deltaAccessTimeMdao.removeTracking(id.uid, id.handle);
        lastRetrievedRevisionTrackerMdao.untrackRevision(id.uid, id.handle);
        return 1;
    }
    deltaAccessTimeMdao.startTracking(id.uid, id.handle, revisionToSetO.get());
    return 0;
}

for (var i = 0;
     i < REMOVING_REPETETIONS
         && (tracked = deltaAccessTimeMdao.getTrackedItemsBefore(expirationInstant, REMOVING_UIDS_BATCH_SIZE)).isNotEmpty();
     i += 1)
{
    removedSnapshotsNow = tracked.stream().mapToInt(removeExpiredDeltas).sum();
    removedSnapshotsCount += removedSnapshotsNow;
    cleanupUids += tracked.size();
    if(removedSnapshotsNow > 0 && i < REMOVING_REPETETIONS - 1) {
        print ("---------------------------------------------------------");
        print ("cleanupUids = " + cleanupUids + ", removedSnapshotsCount = " + removedSnapshotsCount);
        print ("time: = " + ru.yandex.misc.time.TimeUtils.secondsStringToNow(startTs));
        print ("RPS: =" + (i * 1000.0 / new Duration(startTs, Instant.now()).getMillis()));
        print ("---------------------------------------------------------");
        ru.yandex.misc.thread.ThreadUtils.doSleep(new Duration(SLEEP_MS));
    }
}

print ("---------Cleanup finished----------");
print ("cleanupUids = " + cleanupUids + ", removedSnapshotsCount = " + removedSnapshotsCount);
print ("time: = " + ru.yandex.misc.time.TimeUtils.secondsStringToNow(startTs));
print ("RPS: =" + (REMOVING_REPETETIONS * REMOVING_UIDS_BATCH_SIZE * 1000.0 / new Duration(startTs, Instant.now()).getMillis()));