#!/usr/bin/python
# -*- coding: utf-8 -*-

import os
import urllib3
import json
import sys

from package.common import get_secret_value


def submit_qloud_deploy(component_name, environment, id):
    if environment in ['production', 'stable']:
        print 'don\'t use this script to deploy to production!'
        return False

    print 'going to deploy component ' + component_name + ' to ' + environment + ' with sandbox resource id ' + id

    oauth_token = get_secret_value('sec-01d2dhwstdn7g0yycbz6xp1hr5', 'qloud_token')

    headers = {
        "Content-type": "application/json",
        "Accept": "application/json",
        "Authorization": "OAuth " + oauth_token
    }

    http = urllib3.PoolManager()
    url = 'https://qloud-ext.yandex-team.ru/api/v1/environment/dump/disk.disk-' + component_name + "." + environment
    print 'Request current state from qloud ' + url
    r = http.request('GET', url, headers=headers)

    if r.status != 200:
        print 'Failed to get environment json. code=' + str(r.status)
        print ''
        print 'Response body'
        print r.data.decode('utf-8')
        return False

    task_data = json.loads(r.data.decode('utf-8'))
    for component in task_data['components']:
        if component['componentName'] == component_name:
            for resource in component['sandboxResources']:
                if resource['symlink'] == "/application.tar.gz":
                    resource['id'] = id
                    resource['localName'] = 'yandex-disk-' + component_name + "-latest.tar.gz"

    r = http.request('POST', 'https://qloud-ext.yandex-team.ru/api/v1/environment/upload/return-header?targetState=DEPLOYED&skipIfNoChange=false',
                     body=json.dumps(task_data).encode('utf-8'),
                     headers=headers)

    print 'Failed to get environment json. code=' + str(r.status)
    print ''
    print 'Response body'
    print r.data.decode('utf-8')


if __name__ == "__main__":
    os.chdir(os.path.abspath(os.path.join(os.path.abspath(sys.argv[0]), os.pardir, os.pardir)))

    if len(sys.argv) < 4:
        print "usage: ./devel/qloud_deploy.py {component_name} {environment} {sandbox_resource_id}"
        exit(1)

    component_name = sys.argv[1]
    environment = sys.argv[2]
    sandbox_resource_id = sys.argv[3]

    submit_qloud_deploy(component_name, environment, sandbox_resource_id)
