importPackage(ru.yandex.bolts.collection);
importPackage(ru.yandex.misc.db.q);
importPackage(ru.yandex.commune.bazinga.impl);
importPackage(ru.yandex.misc.thread);

var celery = getField(celeryMonitor, 'celery');
var callbacks = getField(celery, 'callbacks');
var key = ru.yandex.chemodan.app.queller.celery.control.CeleryControl.Method.INSPECT_ACTIVE;
var originalCallback = callbacks.get(key);

var tasksByWorkers = Cf.concurrentHashMap();

var newCallback = new ru.yandex.chemodan.app.queller.celery.control.callback.CeleryInspectActiveCallback(){
    onMessageGet: function (info, replies) {
        var workerId = info.workerId;
        var tasks = replies.map(function (r) {return r.id}).unique();
        tasksByWorkers.put(workerId, tasks);
        originalCallback.onMessageGet(info, replies);
    }
};

celery.registerCallback(newCallback);

function getRunningTasksByCelery() {
    return tasksByWorkers.values().flatten().unique();
}

ThreadUtils.sleep(1000);

print(getRunningTasksByCelery().mkString(","))