importPackage(ru.yandex.commune.bazinga.impl);
importPackage(ru.yandex.commune.bazinga.scheduler);
importPackage(ru.yandex.misc.log.mlf);
importPackage(ru.yandex.commune.bazinga.scheduler.schedule)

scriptText =
    "importPackage(ru.yandex.bolts.collection);" +
    "importPackage(ru.yandex.misc.db.q);" +
    "importPackage(ru.yandex.commune.bazinga.impl);" +
    "importPackage(ru.yandex.misc.thread); " +
    "" +
    "var celery = getField(celeryMonitor, 'celery'); " +
    "var callbacks = getField(celery, 'callbacks'); " +
    "var key = ru.yandex.chemodan.queller.celery.control.CeleryControl.Method.INSPECT_ACTIVE; " +
    "" +
    "var originalCallback = callbacks.get(key); var tasksByWorkers = Cf.concurrentHashMap(); " +
    "" +
    "var newCallback = new ru.yandex.chemodan.queller.celery.control.callback.CeleryInspectActiveCallback(){" +
    "    onMessageGet: function (info, replies) {" +
    "        var workerId = info.workerId;" +
    "        var tasks = replies.map(function (r) {return r.id}).unique();" +
    "        tasksByWorkers.put(workerId, tasks);" +
    "        originalCallback.onMessageGet(info, replies);" +
    "    }" +
    "};" +
    "" +
    "celery.registerCallback(newCallback);" +
    "function getRunningTasksByCelery() {" +
    "    return tasksByWorkers.values().flatten().unique();" +
    "} " +
    "" +
    "ThreadUtils.sleep(30000);" +
    "" +
    "celery.registerCallback(originalCallback);" +
    "" +
    "print(getRunningTasksByCelery().mkString(','))";

ids1 = jdbcTemplate.queryForList("Select id from job where status='running' and worker_id is NULL;", (new java.lang.String("")).getClass());

ids2 = Cf.arrayList();
h = Cf.list("queller01g.disk.yandex.net", "queller01f.disk.yandex.net", "queller01h.disk.yandex.net", "queller01e.disk.yandex.net")

for (var i = 0; i < h.size(); i++) {
    host = h.get(i);

    httppost = new org.apache.http.client.methods.HttpPost("http://" + host + ":30811/z/script.json");
    params = Cf.arrayList();
    params.add(new org.apache.http.message.BasicNameValuePair("query", scriptText));

    httppost.setEntity(new org.apache.http.client.entity.UrlEncodedFormEntity(params, "UTF-8"));
    str = ru.yandex.misc.io.http.apache.v4.ApacheHttpClientUtils.executeReadString(httppost);

    ids2.addAll(Cf.list(str.substring(8, str.length()-4).split(",")));
}

ids3 = jdbcTemplate.queryForList("Select id from job where status='running'  and worker_id is NULL;", (new java.lang.String("")).getClass());

intersect = ids3.unique().intersect(ids1.unique());
minus = intersect.minus(ids2.unique());

logger = ru.yandex.misc.log.mlf.LoggerFactory.getLogger("mpfs-mworker-restart");

logger.info ("running pg 2 = " + ids1.size());
logger.info ("running on workers = " + ids2.size());
logger.info ("running pg 2 = " + ids3.size());
logger.info ("running intesect = " + intersect.size());
logger.info ("bad tasks = " + minus.size());
logger.info (minus.mkString("Select * from job where id in ('", "', '", "')"));
logger.info("UPDATE job set status='ready' where id in " + minus.mkString("('", "', '", "')"));

if (minus.size() > 0) {
    jdbcTemplate.execute("UPDATE job set status='ready' where id in " + minus.mkString("('", "', '", "')"));
    logger.info("RESTARTED BAD " + minus.size());
} else {
    logger.info("NO BAD tasks!");
}

context.saveExecutionInfoImmediately(new ru.yandex.chemodan.app.dataapi.web.pojo.DatabasePojo(
    0, minus.size(), Instant.now(), Instant.now(), 0, "", Option.none(), ""
));