#!/bin/bash
set -e

ec() {
    echo "$@"
    "$@"
}

err_exit() {
    echo "$@" >&2
    exit 1
}

if [ $# -eq 0 ]; then
    err_exit "Version not given"
fi

changelog_path=$(dirname $0)/../debian/changelog
package_name=$(head -n 1 ${changelog_path} | sed 's/^ *\([^ ]*\) .*$/\1/')
new_version=$1
current_time=$(LC_ALL=en date +'%a, %d %b %Y %H:%M:%S %z')

tmpfile=tmp.changelog.file
echo -e "$package_name ($new_version) precise; urgency=low\n" \
"\n" \
" * ver++\n" \
"\n" \
"-- $DEBFULLNAME <$USER@yandex-team.ru>  $current_time\n" \
| cat - ${changelog_path} >$tmpfile

mv $tmpfile ${changelog_path}
