importClass(ru.yandex.misc.log.mlf.LoggerFactory);
importPackage(ru.yandex.chemodan.app.dataapi.api.deltas);
importPackage(ru.yandex.chemodan.app.dataapi.api.data.field);
importPackage(ru.yandex.chemodan.app.dataapi.api.user);
importPackage(ru.yandex.chemodan.app.dataapi.api.db.ref);
importPackage(ru.yandex.chemodan.app.dataapi.api.data.filter.condition);

var logger = LoggerFactory.getLogger("smartcache-recreator");

var executer = java.util.concurrent.Executors.newFixedThreadPool(100, new ru.yandex.misc.thread.factory.ThreadNameIndexThreadFactory("smartcache-recreator"));

var uids = (new File2("/tmp/drop_snapshot_uids.txt")).readLines().flatMap(function(x){return Cf.Long.parseSafe(x)}).unique();

function processUid(rawUid) {
    var uid = DataApiUserId.parse("" + rawUid)

    for (var i = 0; i < 5; i++) {
        try {
            photosliceProcessingManager.dropSnapshot(uid);
            photosliceProcessingManager.handleSnapshotInit(uid, true, true);
            logger.info("Scheduled recreate for uid = {}", uid);
            return;
        } catch(e) {
            logger.warn("Failed to reindex uid {} : {}", uid, e)
            ru.yandex.misc.thread.ThreadUtils.sleep(1000)
        }
    }
    logger.warn("Finally failed to reindex uid {} : {}", uid)
}

uids.forEach(function(uid) {
    var finalUid = uid
    executer.submit(new java.lang.Runnable(function() {processUid(finalUid);}));
});

executer.shutdown();