importPackage(org.apache.http.client.methods);
importPackage(org.apache.http.message);
importPackage(org.apache.http.client.entity);
importPackage(ru.yandex.misc.io.http.apache.v4);
importPackage(ru.yandex.chemodan.util.json);
importClass(ru.yandex.misc.random.Random2)
importClass(ru.yandex.misc.log.mlf.LoggerFactory);

var logger = LoggerFactory.getLogger("init-smartcache");

function executeScript(component, scriptTextOrFunction) {
    if (typeof scriptTextOrFunction == 'function') {
        scriptTextOrFunction = "x = " + scriptTextOrFunction + "; x()";
    }

    var hosts = aliveAppsHolder.aliveApps().filterMap(function (app) {
        return Option.when(app.getAppName().equals(component), app.getHostname());
    });

    var port = properties.getProperty(component + ".admin.http.port");

    var results = Cf.arrayList();

    var host = Random2.R.randomElement(hosts);

    var httppost = new HttpPost("http://" + host + ":" + port + "/z/script.json");

    httppost.setEntity(new UrlEncodedFormEntity(Cf.list(new BasicNameValuePair("query", scriptTextOrFunction)), "UTF-8"));

    return JsonNodeUtils.getNode(ApacheHttpClientUtils.executeReadString(httppost));
}

yandexStaffUserRegistry.getAllExternalUids().forEach(function(uid) {
    logger.info("Init photoslice for uid={}", uid);
    try {
        logger.info("status={}", executeScript("smartcache-worker", "photosliceProcessingManager.handleSnapshotInit(ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId.parse(\"" + uid + "\"), true, true)"));
    } catch(e) {logger.error("Failed for uid={} : {}", uid, e)}
})