#!/bin/sh

ec() {
    echo "$@" >&2
    "$@"
}


clear
cd ../..

TRUNK_VER=`grep 'Version' *.spec | grep -oP '\d.*$'`
BRANCH_PREFIX="${TRUNK_VER%.0*}"
BRANCH_NAME="${BRANCH_PREFIX}.x"
BRANCH_VER="${BRANCH_PREFIX}.1"

echo "Trunk version = $TRUNK_VER, branch name = $BRANCH_NAME, branch version = $BRANCH_VER"
read -n 1 -p "Going to create this branch now. Are you sure? If so, press ENTER to continue"

echo
ec hg up default
ec hg branch "$BRANCH_NAME"
ec $YANDEX_BUILD/pkg-build/rpm/rpmchange.pl -u "Sergey Sytnik <ssytnik@yandex-team.ru>" -f *.spec -r -v "$BRANCH_VER"
ec hg branch
ec hg diff
ec hg com -m "ver++" *.spec

echo
ec hg up default
ec $YANDEX_BUILD/pkg-build/rpm/rpmchange.pl -u "Sergey Sytnik <ssytnik@yandex-team.ru>" -f *.spec -r
ec hg diff
ec hg com -m "close section" *.spec

echo
ec hg out
read -n 1 -p "Press ENTER to push changes to mercurial"
ec hg push --new-branch
