#!/usr/bin/python
# -*- coding: utf-8 -*-

import os
import urllib3
import json
import sys

from package.build_component import debian_components
from package.common import get_secret_value


def submit_sandbox_build(branch_name, build_type, component_name=None, deploy_testing=False, deploy_prestable=False, build_args=''):
    if branch_name == 'master' and not component_name:
        print 'Not specified component name for master branch'
        return False

    if branch_name != 'master':
        component_name = None

    build_args = ' ' + build_args if build_args else ''
    if component_name:
        cmdline = "./sandbox_build.sh " + branch_name + " " + component_name + " --dist --upload --" + build_type + build_args
    else:
        cmdline = "./sandbox_build.sh " + branch_name + " --dist --upload --" + build_type + build_args

    if deploy_testing:
        cmdline += " --deploy-testing"

    if deploy_prestable:
        cmdline += " --deploy-prestable"

    json_template = {
        "type": "RUN_SCRIPT",
        "owner": "DISK-ADMIN",
        "description": "Сборка пакета из ветки " + branch_name,
        "context": {
            "script_url": "svn+ssh://zomb-sandbox-rw@arcadia.yandex.ru/arc/trunk/arcadia/disk/devel/package",
            "cmdline": cmdline,
            "kill_timeout": 10800,
            "vault_env": "SANDBOX_TOKEN=DISK-ADMIN:DISK_SANDBOX_TOKEN"
                         " YA_TOKEN=DISK-ADMIN:DISK_SANDBOX_TOKEN"
                         " GPG_SECRET_KEY=DISK-ADMIN:robot-disk-j-build-gpg-private"
                         " GPG_PUBLIC_KEY=DISK-ADMIN:robot-disk-j-build-gpg-public"
                         " SSH_PRIVATE_KEY=DISK-ADMIN:robot-disk-j-build-ssh"
                         " QLOUD_TOKEN=DISK-ADMIN:DISK_QLOUD_TOKEN"
        },
        "requirements": {
            "client_tags": "GENERIC",
            "ram": 1073741824,
            "cpu_model": "",
            "porto_layers": [],
            "platform": "",
            "host": "",
            "dns": "dns64",
            "cores": 0,
            "disk_space": 32212254720,
            "caches": {}
        },
        "priority": {
            "class": "USER",
            "subclass": "HIGH"
        },
        "kill_timeout": 10800,
        "notifications": [
            {
                "transport": "telegram",
                "recipients": [
                    os.environ["USER"]
                ],
                "statuses": [
                    "EXCEPTION",
                    "SUCCESS",
                    "EXPIRED",
                    "FAILURE",
                    "TIMEOUT",
                    "NO_RES"
                ]
            },
            {
                "transport": "email",
                "recipients": [
                    os.environ["USER"]
                ],
                "statuses": [
                    "EXCEPTION",
                    "SUCCESS",
                    "EXPIRED",
                    "FAILURE",
                    "TIMEOUT",
                    "NO_RES"
                ]
            }
        ]
    }

    task_json = json_template

    # print "Submit json to sandbox: \n" + json.dumps(task_json).encode('utf-8')
    oauth_token = get_secret_value('sec-01d0yhkvj5x6wwjq32gtqjt8h3', 'SANDBOX_TOKEN')
    if not oauth_token:
        print "can't get robot oauth token"
        return False

    headers = {
        "Content-type": "application/json",
        "Accept": "application/json",
        "Authorization": "OAuth " + oauth_token
    }

    http = urllib3.PoolManager()
    r = http.request('POST', 'https://sandbox.yandex-team.ru/api/v1.0/task', body=json.dumps(task_json).encode('utf-8'), headers=headers)
    if r.status != 201:
        print 'Failed to create task draft. code=' + str(r.status)
        print ''
        print 'Response body'
        print r.data.decode('utf-8')
        return False

    task_data = json.loads(r.data.decode('utf-8'))
    task_id = task_data['id']

    r = http.request('PUT', 'https://sandbox.yandex-team.ru/api/v1.0/batch/tasks/start', body=json.dumps({"id": [task_id]}).encode('utf-8'), headers=headers)
    if r.status != 200:
        print 'Failed to start task execution. code=' + str(r.status)
        print ''
        print 'Response body'
        print r.data.decode('utf-8')
        return False

    print "--------------------------------------------------------------"
    print "Build task started: https://sandbox.yandex-team.ru/task/" + str(task_id) + "/view"
    print "--------------------------------------------------------------"
    return True

def extract_branch_version(branch_name):
    try:
        return int(branch_name.split('.')[-1])
    except Exception as e:
        return -1

def find_last_branch_for_component(component_name):
    all_branches = os.popen("devel/list_branches.sh").readlines()
    branch_name = None
    branch_version = -1
    for branch in all_branches:
        branch = branch.replace("\n", "").replace(" ", "").replace("/", "")
        if ('release_' + component_name) in branch:
            version = extract_branch_version(branch)
            if version > branch_version:
                branch_name = branch
                branch_version = version

    return branch_name


if __name__ == "__main__":
    os.chdir(os.path.abspath(os.path.join(os.path.abspath(sys.argv[0]), os.pardir, os.pardir)))

    args = sys.argv
    build_args = ''

    if '--' in args:
        build_args_offset = args.index('--')
        if (build_args_offset + 1) < len(args):
            build_args = ' '.join(args[(build_args_offset + 1):])
        args = args[:build_args_offset]

    deploy_testing = ("--deploy_testing" in args)
    deploy_prestable = ("--deploy_prestable" in args)

    args = [a for a in args if a not in ["--deploy-testing", "--deploy-prestable"]]

    if len(sys.argv) == 1:
        print "usage: ./devel/start_sandbox_build.py {branch_name} - build from branch"
        print "usage: ./devel/start_sandbox_build.py {component_name} - build last branch for component"
        print "usage: ./devel/start_sandbox_build.py {component_name} master - build component from master"
        exit(1)

    branch_name = None
    component_name = None

    if 'release' in args[1]:
        branch_name = args[1]
        component_name = args[1].split('_')[1]
    else:
        component_name = args[1]
        if len(args) == 3:
            branch_name = args[2]
        else:
            branch_name = find_last_branch_for_component(component_name)
            if not branch_name:
                print "Can't find any branch for component" + component_name
                exit(1)

    if not branch_name:
        print 'Don\'t known how to build'
        print 'branch_name = ' + str(branch_name)
        print 'build_type = ' + str(build_type)
        print 'component_name = ' + str(component_name)
        exit(1)

    print 'Starting build'
    print 'branch_name = ' + str(branch_name)
    print 'component_name = ' + str(component_name)

    if not submit_sandbox_build(branch_name, 'tar', component_name, deploy_testing=deploy_testing, deploy_prestable=deploy_prestable, build_args=build_args):
        print 'Failed to start build'
        exit(1)

    if component_name in debian_components:
        print 'build debian package too'
        if not submit_sandbox_build(branch_name, 'debian', component_name):
            print 'Failed to start build'
            exit(1)
