importPackage(org.apache.http.client.methods);
importPackage(org.apache.http.message);
importPackage(org.apache.http.client.entity);
importPackage(ru.yandex.chemodan.app.dataapi.utils.dataconversion);
importPackage(ru.yandex.commune.bazinga.impl);
importPackage(ru.yandex.commune.bazinga.scheduler);
importPackage(ru.yandex.misc.log.mlf);
importPackage(ru.yandex.commune.bazinga.scheduler.schedule);

function executeScript(component, scriptText) {
    host = aliveAppsHolder.aliveApps().find(function (app) {
        return app.getAppName().equals(component)
    }).get().getHostname();
    port = properties.getProperty(component + ".admin.http.port")

    httppost = new HttpPost("http://" + host + ":" + port + "/z/script.json");
    params = Cf.arrayList();
    params.add(new BasicNameValuePair("query", scriptText));

    httppost.setEntity(new UrlEncodedFormEntity(params, "UTF-8"));

    node = JsonNodeUtils.getNode(ru.yandex.misc.io.http.apache.v4.ApacheHttpClientUtils.executeReadString(httppost));
    return node.get("result").asText();
}

scriptText = "t = shardManager.getShard(1).getJdbcTemplate3();\n" +
    "\n" +
    "function zeroPad(num, places) {\n" +
    "    var zero = places - num.toString().length + 1;\n" +
    "    return Array(+(zero > 0 && zero)).join(\"0\") + num;\n" +
    "}\n" +
    "\n" +
    "function print_stats (name, query) {\n" +
    "    comments = t.queryForInt(\"Select count(*) from comment where deleted_at is null and \" + query)\n" +
    "\n" +
    "    likes1 = t.queryForInt(\"Select count(*) from entity_like_dislike where attitude='like' and \" + query)\n" +
    "    likes2 = t.queryForInt(\"Select count(*) from comment_like_dislike where attitude='like' and \" + query)\n" +
    "\n" +
    "    dislikes1 = t.queryForInt(\"Select count(*) from entity_like_dislike where attitude='dislike'  and \" + query)\n" +
    "    dislikes2 = t.queryForInt(\"Select count(*) from comment_like_dislike where attitude='dislike' and \" + query)\n" +
    "\n" +
    "    return \"fielddate=\" + name + \"\\t\" + \"comments=\" + comments + \"\\t\" + \"likes=\" + (likes1 + likes2) + \"\\t\" + \"dislikes=\" + (dislikes1 + dislikes2);\n" +
    "}\n" +
    "\n" +
    "cal = java.util.Calendar.getInstance();\n" +
    "cal.setTime(new java.util.Date(Instant.now().minus(Duration.standardDays(1)).getMillis()));\n" +
    "\n" +
    "var day = cal.get(java.util.Calendar.DAY_OF_MONTH);\n" +
    "var month = cal.get(java.util.Calendar.MONTH) + 1;\n" +
    "var year = cal.get(java.util.Calendar.YEAR);\n" +
    "\n" +
    "cal.setTime(new java.util.Date(Instant.now().minus(Duration.standardDays(2)).getMillis()));\n" +
    "var y_day = cal.get(java.util.Calendar.DAY_OF_MONTH);\n" +
    "var y_month = cal.get(java.util.Calendar.MONTH) + 1;\n" +
    "var y_year = cal.get(java.util.Calendar.YEAR);\n" +
    "\n" +
    "query = \" created_at > '\" + y_year + \"-\" + zeroPad(y_month, 2) + \"-\" + zeroPad(y_day, 2) + \" 21:00:00' and created_at < '\" + year + \"-\" + zeroPad(month, 2) + \"-\" + zeroPad(day, 2) + \" 21:00:00'\";\n" +
    "print_stats(year + \"-\" + zeroPad(month, 2) + \"-\" + zeroPad(day, 2), query);\n";

statfaceData = executeScript("comments", scriptText);


httppost = new org.apache.http.client.methods.HttpPost("https://upload.stat.yandex-team.ru/_api/report/data");
httppost.addHeader("StatRobotAuth", "robot_tolmalev:5tici2i1annousl");

params = Cf.arrayList();
params.add(new org.apache.http.message.BasicNameValuePair("name", "Disk/comments/NewByDay"));
params.add(new org.apache.http.message.BasicNameValuePair("scale", "d"));
params.add(new org.apache.http.message.BasicNameValuePair("data", statfaceData));

httppost.setEntity(new org.apache.http.client.entity.UrlEncodedFormEntity(params, "UTF-8"));

print(ru.yandex.misc.io.http.apache.v4.ApacheHttpClientUtils.executeReadString(httppost, true));