shards = Cf.list(dataShardManager.shards());

function zeroPad(num, places) {
    var zero = places - num.toString().length + 1;
    return Array(+(zero > 0 && zero)).join("0") + num;
}

cntUsers = 0;
cntDatabases = 0;
cntRecords = 0;
cntDeltas = 0;

for (var j = 0; j < shards.size(); j++) {
    template = shards.get(j).getJdbcTemplate3();
    for (var i = 0; i < 128; i++) {
        cntUsers += template.queryForInt("Select count(distinct user_id) from databases_" + zeroPad(i, 3));
        cntDatabases += template.queryForInt("Select count(*) from databases_" + zeroPad(i, 3));
        cntRecords += template.queryForInt("Select count(*) from p_data_" + zeroPad(i, 3));
        cntDeltas += template.queryForInt("Select count(*) from deltas_" + zeroPad(i, 3));
    }
}

print ("Users: " + cntUsers);
print ("Databases: " + cntDatabases);
print ("Records: " + cntRecords);
print ("Deltas: " + cntDeltas);
