#!/bin/bash -e

CHE_UID=${CHE_UID:-16011578}
FILE_ID=${FILE_ID:-helloworld}
FILE_PATH=${FILE_PATH:-/foo/bar}
HOST=${HOST:-localhost}
OPTS=-k

if [ "$1" = "upload" ]; then
    WHAT="$2"

    curl $OPTS -d api=0.2 -d uid=$CHE_UID -d file-id=$FILE_ID -d path=$FILE_PATH http://$HOST:32450/upload-url/disk  >result
    UPLOAD_TARGET_URL=`xmlstarlet sel -t -v /upload/@post-target <result`
    UPLOAD_STATUS_URL=`xmlstarlet sel -t -v /upload/@poll-result <result`

    curl $OPTS -X PUT --data-binary "@$WHAT" $UPLOAD_TARGET_URL

    sleep 1
    curl $OPTS -v $UPLOAD_STATUS_URL

elif [ "$1" = "patch-uploaded" ]; then
    UPLOAD_STATUS_URL="$2"
    PATCH="$3"
    PATCHED_MD5="$4"

    echo "Retrieving upload status..."
    curl $OPTS $UPLOAD_STATUS_URL >result
    MULCA_ID=`xmlstarlet sel -t -v /upload-info/stages/mulca-file/result/@mulca-id <result`
    ORIGINAL_MD5=`xmlstarlet sel -t -v /upload-info/stages/incoming-file/result/@md5 <result`

    echo "Retrieving status..."
    curl $OPTS -d api=0.2 -d uid=$CHE_UID -d file-id=$FILE_ID -d path=$FILE_PATH -d original-md5=$ORIGINAL_MD5 -d mulca-id=$MULCA_ID http://$HOST:32410/patch-url/disk >result
    DELTA_TARGET_URL=`xmlstarlet sel -t -v /upload/@delta-target <result`
    DELTA_STATUS_URL=`xmlstarlet sel -t -v /upload/@poll-result <result`

    echo "PUTting patch..."
    curl $OPTS -X PUT -H "Content-Type: application/octet-stream" -H "If-Match: $ORIGINAL_MD5" -H "Yandex-Diff: $PATCHED_MD5" --data-binary "@$PATCH" $DELTA_TARGET_URL

    sleep 1
    curl $OPTS -v $DELTA_STATUS_URL

elif [ "$1" = "upload-from-service-mail" ]; then
    MULCA_ID="$2"

    curl $OPTS -d api=0.2 -d uid=$CHE_UID -d file-id=$FILE_ID -d path=$FILE_PATH -d source-service=mail -d service-file-id=$MULCA_ID http://$HOST:32450/upload-from-service >result
    UPLOAD_STATUS_URL=`xmlstarlet sel -t -v /upload/@poll-result <result`

    sleep 1
    curl $OPTS -v $UPLOAD_STATUS_URL

elif [ "$1" = "put-to-mulca" ]; then
    WHAT="$2"
    PARAM_TAIL="$3" # e.g. "?msg"

    MULCA_HOST="localhost" #"storagetest.mail.yandex.net"
    MULCA_PUT_URL="http://$MULCA_HOST:10010/gate/put/$CHE_UID$PARAM_TAIL"
    echo "POSTing $WHAT to $MULCA_PUT_URL"

    curl $OPTS -X POST --data-binary "@$WHAT" $MULCA_PUT_URL

else
    echo "unknown command"
    exit 1
fi

