importPackage(ru.yandex.inside.yt.kosher.cypress);
importPackage(ru.yandex.inside.yt.kosher.tables);
importPackage(ru.yandex.chemodan.app.dataapi.api.user);
importPackage(ru.yandex.chemodan.app.migrator.tasks);
importPackage(ru.yandex.misc.log.mlf);

var logger = LoggerFactory.getLogger("Cleaner");
new Array('', '0', '0V', '1B', '1I', '1V', '2', '2V', '2B', '3', '3B', '3I', '3V').forEach(function(suffix) {
    this['f' + suffix] = function(func) {
        return new (Java.extend(ru.yandex.bolts['function']['Function' + suffix], {
            apply: function() {
                return func.apply(this, arguments);
            }
        }))()
    };
});

var path = '//home/fill_it'

var from = 0;
var to = 10000;

threads = 20;

pathWithRange = YPath.simple(path).withRange(from, to);

sharpeiId = getField(bazingaUserMigrationManager, 'sharpeiId');

executor = java.util.concurrent.Executors.newFixedThreadPool(threads);

var counter = new java.util.concurrent.atomic.AtomicInteger(from);


function clean(row) {
    var counterValue = counter.getAndIncrement();

    var uid = DataApiUserId.parse(row.get('user_id').textValue());
    var userShard = dbFriendlyUserMigrationManager.getUserShard(uid);

    logger.info('{} scheduling {}', counterValue, uid)

    var shards = row.get('shards');
    logger.info("About to schedule " + counterValue + ", shards:" + shards + ", userShard:" + userShard);
    shards.forEach(function (shard) {
        var shardId = shard.intValue();

        if (userShard != shardId) {
            logger.info("Started task: " + row);
            bazingaTaskManager.schedule(new DatasyncMigrationCleanUpTask(uid, shardId, sharpeiId), Instant.now());
        }
    });
}

dataApiYtClient.tables().read(pathWithRange, YTableEntryTypes.JACKSON,
    f(function(it) {
        it.forEachRemaining(function (row) {
            logger.info("to executed " + row);
            executor.submit(function () {
                try {
                    logger.info("executing " + row);
                    clean(row.deepCopy());
                } catch (e) {
                    logger.info('failed {}', e);

                }
            }, null);
        });
        return true;
    }))
