importPackage(java.lang);
importPackage(ru.yandex.bolts.collection);
importPackage(ru.yandex.chemodan.app.dataapi.worker);
importPackage(ru.yandex.chemodan.mpfs);
importPackage(ru.yandex.commune.util);
importPackage(ru.yandex.inside.mulca);
importPackage(ru.yandex.inside.yt.kosher);
importPackage(ru.yandex.inside.yt.kosher.cypress);
importPackage(ru.yandex.inside.yt.kosher.impl.ytree.builder);
importPackage(ru.yandex.inside.yt.kosher.tables);
importPackage(ru.yandex.inside.yt.kosher.ytree);
importPackage(ru.yandex.misc.bender.annotation);
importPackage(ru.yandex.misc.dataSize);
importPackage(ru.yandex.misc.io.http);
importPackage(ru.yandex.misc.log.mlf);

importPackage(ru.yandex.inside.yt.kosher.impl);
importPackage(ru.yandex.inside.yt.kosher.cypress);
importPackage(ru.yandex.inside.yt.kosher.tables);
importPackage(ru.yandex.chemodan.app.dataapi.api.user);

new Array('', '0', '0V', '1B', '1I', '1V', '2', '2V', '2B', '3', '3B', '3I', '3V').forEach(function(suffix) {
    this['f' + suffix] = function(func) {
        return new (Java.extend(ru.yandex.bolts['function']['Function' + suffix], {
            apply: function() {
                return func.apply(this, arguments);
            }
        }))()
    };
});

var logger = LoggerFactory.getLogger("YtFileUploader");

function upload(dstPath, cvExportYtPath) {
        var dst = YPath.simple(dstPath);
        var path = YPath.simple(cvExportYtPath).withRange(0, 10000);

        var proxy = "hahn.yt.yandex-team.ru";
        var token = "";
        var yt = YtUtils.http(proxy, token);
        var fileLoads = yt.tables().read(path, YTableEntryTypes.YSON, f(function(it) {
            return it.toList();
        }));

        yt.tables().write(
                Option.empty(),
                false,
                dst,
                YTableEntryTypes.YSON,
                fileLoads.iterator().filterMap(function(load) {
                    logger.info("uid: " + load.getString("puid") + ", stid: " + load.getString("stid"));
                    var builder = YTree
                            .mapBuilder()
                            .key("uid").value(load.getString("puid"))
                            .key("stid").value(load.getString("stid"))
                            .key("disk_lat").value(load.getDouble("disk_lat"))
                            .key("disk_lon").value(load.getDouble("disk_lon"))
                            .key("distance").value(load.getDouble("distance"))
                            .key("report_lat").value(load.getDouble("report_lat"))
                            .key("report_lon").value(load.getDouble("report_lon"));


                    var fileContent = RetryUtils.retryE(logger, 10, f0(function() {
                            return Option.of(mulcaClient.download(MulcaId.fromSerializedString(load.getString("stid"))).readBytes());
                    }));

                    if (fileContent.isRight()) {
                        logger.error("Can't fetch file" + fileContent.getRight());
                        return Option.empty();
                    }

                    if (fileContent.getLeft().isPresent()) {
                        if (fileContent.getLeft().get().length > DataSize.fromMegaBytes(19).toBytes()) {
                            return Option.empty();
                        }
                        builder.key("content").value(fileContent.getLeft().get());
                    } else {
                        return Option.empty();
                    }
                    logger.info("uid: " + load.getString("puid") + ", stid: " + load.getString("stid") + ", size: " + fileContent.getLeft().get().length);
                    return Option.of(builder.buildMap());
                }), new TableWriterOptions(DataSize.fromMegaBytes(20)));
                logger.info("finished")
    }


java.util.concurrent.CompletableFuture.runAsync(new function() {
    var cvExportYtPath = "";
    var dstPath = "";
    upload(dstPath, cvExportYtPath);
})