importPackage(java.lang);
importPackage(java.util.stream);
importPackage(java.nio.file);
importPackage(java.io);
importPackage(java.util.concurrent);
importPackage(org.joda.time);
importPackage(ru.yandex.misc.log.mlf);
importPackage(ru.yandex.inside.yt.kosher.operations.specs);
importPackage(ru.yandex.misc.log.reqid);
importPackage(ru.yandex.misc.reflection);
importPackage(ru.yandex.misc.db.masterSlave);
importPackage(ru.yandex.bolts.function);
importPackage(ru.yandex.misc.io.file);
importPackage(ru.yandex.misc.random);
importPackage(ru.yandex.inside.mulca);
importPackage(ru.yandex.commune.json.serialize);
importPackage(ru.yandex.misc.thread);
importPackage(ru.yandex.misc.thread.factory);
importPackage(ru.yandex.chemodan.uploader.exif);

var logger = LoggerFactory.getLogger("ExifFetcherJob")
var t = new File(System.getProperty("java.io.tmpdir"));
var tempDir = new File(t, "exif_temp");
var resDir = new File(t, "exif_out");
resDir.mkdirs();
tempDir.mkdirs();
print("resDir=" + resDir);

var srcFile = new File2("/u0/disk/uploader/tmp/exif_src/yt");
print("srcFile=" + srcFile);
var parser = new JsonParser();
var ex = Executors.newFixedThreadPool(250, new ThreadNameThreadFactory("exif-tp"))
mapF = function(line) {
  ex.execute(function() {
        try {
           var split = line.split("\t");
           var stid = split[0].trim();
           var uid = split[1].trim();

           var outFile = new File(resDir, stid)
           if (outFile.exists()) {
               return;
           }
           var tempFileExif = new File2(tempDir, stid);
           var downloadedInfo = stages.downloadFromMulcaF(MulcaId.fromSerializedString(stid), tempFileExif).call();
           try {
             exif = ExifTool.INSTANCE.getExif(tempFileExif, Duration.standardMinutes(1));
             var result = '{"uid":"' + uid + '","stid":"' + stid + '","date":' + exif.getCreationDate().get().getMillis() + '}'
             outFile.createNewFile();
             Files.write(outFile.toPath(), result.getBytes(), StandardOpenOption.CREATE);
           } catch (e) {
               try{
                   logger.warn("Failed to fetch exif: {}, {}", stages.extractFullExifInJsonF(tempFileExif).call(), stid, e);
               } catch (e) {
                   logger.warn("Failed to fetch exif:, {}", stid, e);
               }
           } finally {
              tempFileExif.deleteIfExists()
           }
       } catch (e) {
           logger.warn("Ooops", e)
       }
  })
}

try {
    var lines = srcFile.readLines();
    lines.stream().forEach(mapF)
} finally {
    ex.shutdown();
}

