var mapper = new com.fasterxml.jackson.databind.ObjectMapper();
var rowMapper = new org.springframework.jdbc.core.RowMapper {
	mapRow: function(rs, rowNum) {
		var node = mapper.createObjectNode();
		var key = rs.getString("user_id");
		var value = rs.getString("ar");
		var array = mapper.valueToTree(java.util.Arrays.asList(value.split(',')));
		node.putArray(key).addAll(array);
		return node;
	}
}

function reportExtractorForShard(shard) {
	var partitionIndex = 0;
	for (partitionIndex = 0; partitionIndex < 128; partitionIndex++) {
		reportFetcherForShardPartitionWithRetries(shard, partitionIndex);
	}
}

function reportFetcherForShardPartitionWithRetries(shard, partitionIndex) {
	ru.yandex.commune.util.RetryUtils.retryO(5, function() {
		var partition = 'p_data_' + ru.yandex.misc.lang.StringUtils.leftPad(partitionIndex, 3, '0');
		var result = shard.getJdbcTemplate3().query("select user_id, string_agg(record_id, ',') as ar from " + partition +
			" where app = 'profile' and dbid in ('geopoints', 'addresses') group by user_id ", rowMapper);
		var fileName = "/tmp/geo-report_" + shard.getShardInfo().getName() + "_" + partitionIndex + ".json";
		print(fileName);
		mapper.writeValue(new java.io.File(fileName), result);
	});
}

var shards = shardPartitionDataSource.shardManager.getWritableShards();
shards.parallelStream().forEach(function(shard) {
	reportExtractorForShard(shard);
})
