importPackage(ru.yandex.chemodan.app.dataapi.api.user);
importPackage(ru.yandex.chemodan.app.dataapi.utils.dataconversion);
importPackage(ru.yandex.misc.db.q);
importPackage(ru.yandex.chemodan.app.dataapi.api.data.filter.ordering)
importPackage(ru.yandex.chemodan.app.dataapi.api.data.filter)
importPackage(ru.yandex.chemodan.app.dataapi.api.db.ref)
importPackage(ru.yandex.chemodan.app.dataapi.api.data.filter.condition)
importPackage(ru.yandex.chemodan.app.dataapi.api.deltas)
importPackage(ru.yandex.chemodan.app.dataapi.api.data.field)
importPackage(java.util.concurrent)
logger = ru.yandex.misc.log.mlf.LoggerFactory.getLogger("isFavor-up");

//tv 	common 	programs
var DS_APP = "tv_test";
var DB_ID = "common";
var COLLECTION = "programs";
var executorService = Executors.newFixedThreadPool(300);
var set = Cf.concurrentHashMap();

var dbRef = DatabaseRef.cons(Option.of(DS_APP), DB_ID);
var collRef = dbRef.consColRef(COLLECTION);

function findDb(uid) {
    return dataApiManager.getDatabaseO(dbSpec(uid));
}

function dbSpec(uid) {
    return new UserDatabaseSpec(uid, dbRef);
}

nativeDataApiManager.getDatabaseUsers(dbRef)
                    .withDbCond(DatabaseCondition.recordsCount().gt(0))
                    .forEachRemaining(function(t) {process(t); } );

function process(users) {
    users.forEach(function(u) {
        processSingleAsync(u);
    })
}

function processSingleAsync(user) {
    executorService.submit(function() {
            processSingle(user);
    },
    null);
}

function processSingle(user) {
    if (set.put(user, 1) != null) {
       return;
    }
    logger.info("user " + user);
    var dbO = findDb(user);
    logger.info("dbO " + dbO);
    if (dbO.isPresent()) {
       var db = dbO.get();
       var snapshot = dataApiManager.getSnapshot(db.spec(), getFilter());
       var ids = snapshot.recordIds();
       ids.forEach(function(recordId) {
              try {
                dataApiManager.applyDelta(db,
                        RecordChange.update(recordId, Cf.list(
                                               FieldChange.put("isFavourite", DataField.bool(true)),
                                               FieldChange.put("addTime", DataField.timestamp(Instant.now())))),
                        ru.yandex.chemodan.app.dataapi.api.data.filter.condition.RecordCondition.all())
                logger.info("Updated " + user);
              } catch(e) {
                logger.error("Can't process user record" + user, e);
              }
           });
       logger.info("Processed " + user);
    }
}

function getFilter() {
    return RecordsFilter.DEFAULT.withColRef(collRef);
}