#! /usr/bin/env python2.7
# -*- coding: utf8 -*-

import sys
import json
import requests

MPFS_HOST = "http://mpfs.disk.yandex.net"
DJFS_HOST = "http://localhost:25699/api/legacy"

HEADERS = {'Content-Type': 'application/json'}

def get_data(host, uri, body):
    return json.loads(requests.post(host + uri, data=body, headers=HEADERS).text)

def sizes_to_dict(sizes):
    return dict([(size['name'], size['url'].replace('&tknv=v2', '').replace('%3D%3D', '==')) for size in sizes])

def same(mpfs_l, djfs_l):
    isOk = True

    for mpfs, djfs in zip(mpfs_l, djfs_l):
        if 'sizes' in mpfs['meta']:
            mpfs['meta']['sizes'] = sizes_to_dict(mpfs['meta']['sizes'])
            djfs['meta']['sizes'] = sizes_to_dict(djfs['meta']['sizes'])
        for key, mpfs_value in mpfs.items():
            djfs_value = djfs.get(key)
            if mpfs_value != djfs_value:
                if key == 'meta':
                    for meta_key, mpfs_meta_value in mpfs_value.items():
                        djfs_meta_value = djfs_value.get(meta_key)
                        if meta_key == 'sizes':
                            for size, mpfs_url in djfs_meta_value.items():
                                djfs_url = djfs_meta_value.get(size)
                                if mpfs_url != djfs_url:
                                    print 'meta.size', size
                                    print mpfs_url
                                    print djfs_url
                        elif mpfs_meta_value != djfs_meta_value:
                            print 'meta', meta_key
                            print json.dumps(mpfs_meta_value, indent=2)
                            print json.dumps(djfs_meta_value, indent=2)
                            isOk = False
                    for meta_key in djfs_value:
                        if meta_key not in mpfs_value:
                            print 'meta', meta_key, 'only in djfs'
                            isOk = False
                else:
                    print key
                    print json.dumps(mpfs_value, indent=2)
                    print json.dumps(djfs_value, indent=2)
                    isOk = False
        for key in djfs:
            if key not in mpfs and key != '__type':
                print key, 'only in djfs'
                isOk = False
    return isOk

def do_ckeck(lines):
    offset = int(sys.argv[1])
    for _id, line in enumerate(lines):
        if _id < offset:
            continue
        uri, paths = line[:-1].split('\t')
        body = json.dumps([path.strip("'") for path in paths.split(', ')])
        mpfs_data = get_data(MPFS_HOST, uri, body)
        djfs_data = get_data(DJFS_HOST, uri, body)

        print _id
        try:
            is_same = same(mpfs_data, djfs_data)
        except Exception as e:
            print 'error', uri, paths
            is_same = False

        if (_id % 100 == 0) or not is_same:
            with open('results.log', 'a') as f:
                f.write('%d %s\n' % (_id, is_same))
        if not is_same:
            print uri, body
            print '%s\t%s' % (uri, paths)
            # break


if __name__ == "__main__":
    do_ckeck(sys.stdin)
    print 'done'
