#! /usr/bin/env python2.7
# -*- coding: utf8 -*-

import sys
import json
import requests

REFERENCE_HOST = "https://mpfs.disk.yandex.net"
DEPLOY_HOST = "https://mpfs.deploy.disk.yandex.net"

HEADERS = {'Content-Type': 'application/json'}

def get_data(host, uri):
    return json.loads(requests.get(host + uri, headers=HEADERS).text)


def check_uri(line_id, uri):
    print line_id
    reference_data = {}
    deploy_data = {}
    for attempt in xrange(0, 20):
        reference_data = get_data(REFERENCE_HOST, uri)
        deploy_data = get_data(DEPLOY_HOST, uri)

        try:
            is_same = reference_data == deploy_data
        except Exception as e:
            print 'error', uri
            is_same = False
        if is_same:
            return True
        else:
            print 'recheck after %d failure' % (attempt)

    with open('result_mismatch_reference_%d.txt' % (line_id), 'w') as f:
        json.dump(reference_data, f, indent=4)
    with open('result_mismatch_deploy_%d.txt' % (line_id), 'w') as f:
        json.dump(deploy_data, f, indent=4)

    return False


def do_ckeck(lines):
    offset = int(sys.argv[1])
    for _id, line in enumerate(lines):
        if _id < offset:
            continue
        uri = line[:-1]

        is_same = check_uri(_id, uri)

        if (_id % 100 == 0) or not is_same:
            with open('results.log', 'a') as f:
                f.write('%d %s\n' % (_id, is_same))
        if not is_same:
            print uri
            with open('mismatches.log', 'a') as f:
                f.write('%s\n' % (uri))
            # break


if __name__ == "__main__":
    do_ckeck(sys.stdin)
    print 'done'
