importPackage(ru.yandex.misc.db.q);
importPackage(ru.yandex.inside.yt.kosher.cypress);
importPackage(ru.yandex.inside.yt.kosher.tables.types);
importPackage(com.fasterxml.jackson.databind.node);
importPackage(ru.yandex.inside.yt.kosher.impl);
importPackage(ru.yandex.misc.db.masterSlave);

new Array('', '0', '0V', '1B', '1I', '1V', '2', '2V', '2B', '3', '3B', '3I', '3V').forEach(function(suffix) {
    this['f' + suffix] = function(func) {
        return new (Java.extend(ru.yandex.bolts['function']['Function' + suffix], {
            apply: function() {
                return func.apply(this, arguments);
            }
        }))()
    };
});

var handleCounts = 1000;
var ytPageSize = 100000;
// Use your own path suffix
var rootFolder = '//home/datasync/...';

var threads = 20;

// var PROXY = "hahn.yt.yandex-team.ru";
// var TOKEN = "";
// var yt = YtUtils.http(PROXY, TOKEN);
var yt = dataApiYtClient;

var shards = dataShardManager.shards().toList();

var filteredShards = shards.filter(function(s) {
    // modify if needed
    var id = s.getShardInfo().getId();
    // Filter here, for example:
    // return id == 75
    return true;
});

var jsonNodeFactory = new JsonNodeFactory(false);

var rowMapper = new org.springframework.jdbc.core.RowMapper{
    mapRow: function(rs, rowNum) {
        var node = jsonNodeFactory.objectNode();
        node.put('user_id', rs.getString('user_id'));
        node.put('handle', rs.getString('handle'));
        node.put('dbid', rs.getString('dbid'));
        node.put('size', rs.getLong('size'));
        return node;
    }
}

function getDatabases(shard, partitionIndex, offsetHandle) {
    var condition = offsetHandle.map(function (handle) {return ConditionUtils.column("handle").gt(handle);})
        .getOrElse(SqlCondition.trueCondition());
    var limits = SqlLimits.first(handleCounts);
    var order = SqlOrder.orderByColumn("handle");

    var partition = 'databases_' + ru.yandex.misc.lang.StringUtils.leftPad(partitionIndex, 3, '0');

    var query = "SELECT user_id, handle, dbid, size FROM " + partition + " " + condition.whereSql() + " "
        + order.toSql() + " "
        + limits.toMysqlLimits();

    return shard.getJdbcTemplate3().query(query, rowMapper, condition.args());
}

function withRetries(action) {
    ru.yandex.commune.util.RetryUtils.retryO(5, action).getOrThrow("failed on reties");
}

function uploadShardPartition(shard, partitionIndex) {
    var shardId = shard.getShardInfo().getId();
    var resultPath = YPath.simple(rootFolder + "/shard" + ru.yandex.misc.lang.StringUtils.leftPad(shardId, 3, '0') + "partition" + ru.yandex.misc.lang.StringUtils.leftPad(partitionIndex, 3, '0')).append(true);

    withRetries(function() {
        yt.cypress().create(resultPath, CypressNodeType.TABLE, true, true);
    });

    var handleOffset = Option.empty();

    var records = Cf.arrayList();

    do {
        var dbs = getDatabases(shard, partitionIndex, handleOffset);
        handleOffset = dbs.lastO().map(function(row) {return row.get('handle').asText()});
        dbs.forEach(function(row) {
            row.remove('handle');
            row.put('shard', shardId);
        });

        records.addAll(dbs);

        if ((records.size() >= ytPageSize) || (dbs.isEmpty())) {
            withRetries(function () {
                yt.tables().write(resultPath, new JacksonTableEntryType(false), records);
            });
            records = Cf.arrayList();
        }
    } while (dbs.isNotEmpty());
    return resultPath;
}

function uploadShard(shard) {
    var latch = new java.util.concurrent.CountDownLatch(128);
    var pathes = Cf.arrayList();
    Cf.range(0, 128).forEach( function (partition) {
        executor.submit(
            function () {
                MasterSlaveContextHolder.withPolicy(MasterSlavePolicy.R_S, f0V(function() {
                    pathes.add(uploadShardPartition(shard, partition));
                }));
                latch.countDown();
            },
            null);
    } );
    latch.await();
    var shardId = shard.getShardInfo().getId();
    var shardTable = YPath.simple(rootFolder + "/shard" + ru.yandex.misc.lang.StringUtils.leftPad(shardId, 3, '0'));
    yt.operations().mergeAndGetOp(pathes, shardTable).await();
    pathes.forEach(function(path) {
        yt.cypress().remove(path);
    })
}

try {
    executor = java.util.concurrent.Executors.newFixedThreadPool(threads);
    filteredShards.forEach(function (shard) {
        uploadShard(shard);
    })
} finally {
    executor.shutdown();
}
