#!/usr/bin/env python
# -*- coding: utf-8 -*-

import requests

app = 'profile'
database_id = 'extracted_addresses'
collection_id = 'common_addresses'

id_property_name = 'address_id'

# {
#     "uid": user_id,
#     "data": [{
#         "address_id": "home",
#         "title": "Home",
#         "longitude": 0,
#         "address_line_short": ".....",
#         "latitude": 0,
#         "address_line": "....."
#     }, {
#        .....
#     }]
# }

data_blocks = [
    {
        "uid": 0,
        "data": []
    }
]

GET_DB = 'http://localhost:21859/api/app/databases/{db}?app={app}&__uid={uid}'
PUT_RECORD = 'http://localhost:21859/api/databases/{db}/collection/{collection}/record/{record_id}?app={app}&__uid={uid}'


def create_db(app, db, uid):
    url = GET_DB.format(db=db, app=app, uid=uid)
    r = requests.put(url)
    print r.text


def put_single_record(app, db, collection, uid, record_dict):
    record_id = record_dict[id_property_name]
    url = PUT_RECORD.format(db=db, collection=collection,
                            record_id=record_id, app=app, uid=uid)
    r = requests.put(url, json={'data': record_dict})
    print r.text


def put_multiple_records(app, db, collection, uid, records):
    if isinstance(records, dict):
        records = [records]

    for record in records:
        put_single_record(app, db, collection, uid, record)


if __name__ == '__main__':
    for block in data_blocks:
        uid = block['uid']
        data = block['data']
        create_db(app, database_id, uid)
        put_multiple_records(app, database_id, collection_id, uid, data)
