importPackage(ru.yandex.inside.yt.kosher.cypress);
importPackage(ru.yandex.inside.yt.kosher.tables);
importPackage(ru.yandex.chemodan.app.dataapi.api.user);
importPackage(ru.yandex.chemodan.app.migrator.tasks);


new Array('', '0', '0V', '1B', '1I', '1V', '2', '2V', '2B', '3', '3B', '3I', '3V').forEach(function(suffix) {
    this['f' + suffix] = function(func) {
        return new (Java.extend(ru.yandex.bolts['function']['Function' + suffix], {
            apply: function() {
                return func.apply(this, arguments);
            }
        }))()
    };
});

var path = '//home/disk-stat/analytics/yashunsky/CHEMODAN-43029/multishard_users'

var from = 0;
var to = 1;

threads = 20;

pathWithRange = YPath.simple(path) //.withRange(from, to);

sharpeiId = getField(bazingaUserMigrationManager, 'sharpeiId');

semaphore = new java.util.concurrent.Semaphore(threads);
executor = java.util.concurrent.Executors.newFixedThreadPool(threads);

var counter = new java.util.concurrent.atomic.AtomicInteger(from);


function clean(row) {
    var counterValue = counter.getAndIncrement();

    var uid = DataApiUserId.parse(row.get('user_id').textValue());
    var userShard = dbFriendlyUserMigrationManager.getUserShard(uid, getField(bazingaUserMigrationManager, 'migrationControl').getSharpeiSemaphore());

    logger.info('{} scheduling {}', counterValue, uid)

    var shards = row.get('shards');
    shards.forEach(function (shard) {
        var shardId = shard.intValue();
        if (userShard != shardId) {
            bazingaTaskManager.schedule(new DatasyncMigrationCleanUpTask(uid, shardId, sharpeiId), Instant.now());
        }
    });
}

dataApiYtClient.tables().read(pathWithRange, YTableEntryTypes.JACKSON,
    f(function(it) {
        it.forEachRemaining(function (row) {
            semaphore.acquire();

            executor.submit(function () {
                try {
                    clean(row.deepCopy());
                } catch (e) {
                    logger.info('failed {}', e);

                } finally {
                    semaphore.release();
                }
            }, null);
        });
        return true;
    }))
