importPackage(ru.yandex.misc.io.file);
importPackage(ru.yandex.chemodan.app.docviewer.convert);

var fileName = '/tmp/to_clean_2019-08-30';

var threads = 10;
var toSkip = 300000;

var semaphore = new java.util.concurrent.Semaphore(threads);
var executor = java.util.concurrent.Executors.newFixedThreadPool(threads);
var linesCounter = new java.util.concurrent.atomic.AtomicInteger(0);
var totalCounter = new java.util.concurrent.atomic.AtomicInteger(0);
var toDeleteCounter = new java.util.concurrent.atomic.AtomicInteger(0);

var logger = ru.yandex.misc.log.mlf.LoggerFactory.getLogger('manualLogger');

invoke = function(obj, name, varargs) {
    return ru.yandex.misc.reflection.MethodX.getSingleMethod(obj.getClass(), name)
        .setAccessibleTrueReturnThis()
        .invoke(obj, arguments.length > 2 ? Array.prototype.slice.call(arguments, 2) : []);
};

function deleteHandler(storedResult) {
    logger.info("processed {} results. current last access is {}", totalCounter.incrementAndGet(), storedResult.getLastAccess());
    if (!invoke(resultsCleanup, 'skipResult', storedResult)) {
        invoke(resultsCleanup, 'cleanupStoredResult', storedResult);
        logger.info("line {}. deleting file {} with last access time: {}", linesCounter.get(), toDeleteCounter.incrementAndGet(), storedResult.getLastAccess());
    }
}

function consume(line) {
    if (linesCounter.incrementAndGet() < toSkip) {
        return;
    }
    var parts = line.split(' ');
    var fileId = parts[0];
    var convertTargetType = TargetType.valueOf(parts[1], null);
    var storedResultO = storedResultDao.find(fileId, convertTargetType);
    if (storedResultO.isPresent()) {
        deleteHandler(storedResultO.get());
    }
}

try {
    new File2(fileName).asReaderSource().forEachLine(function(line) {
        semaphore.acquire();

        executor.submit(function () {
            try {
                consume(line);
            } catch (e) {
                logger.error('failed to delete {}: {}', line, e)
            } finally {
                semaphore.release();
            }
        }, null);
    })
} finally {
    executor.shutdown();
}
