importPackage(com.mongodb);
importPackage(ru.yandex.chemodan.app.docviewer.adapters.mongo);

invoke = function(obj, name, varargs) {
    return ru.yandex.misc.reflection.MethodX.getSingleMethod(obj.getClass(), name)
        .setAccessibleTrueReturnThis()
        .invoke(obj, arguments.length > 2 ? Array.prototype.slice.call(arguments, 2) : []);
};

new Array('', '0', '0V', '1B', '1I', '1V', '2', '2V', '2B', '3', '3B', '3I', '3V').forEach(function(suffix) {
    this['f' + suffix] = function(func) {
        return new (Java.extend(ru.yandex.bolts['function']['Function' + suffix], {
            apply: function() {
                return func.apply(this, arguments);
            }
        }))()
    };
});

var logger = ru.yandex.misc.log.mlf.LoggerFactory.getLogger('manualLogger');

var initialOffset = Option.of(Instant.parse('2019-04-08T06:43:59.575Z'));
var daysBefore = 90;
var limit = 200;
var threads = 410;

var deadline = Instant.now().minus(Duration.standardDays(daysBefore));
var LAST_ACCESS_COLUMN = 'last-access-time';
var mainCondition = new BasicDBObject(LAST_ACCESS_COLUMN, new BasicDBObject("$lt", deadline.toDate()));
var dbCollection = invoke(mongoStoredResultDao, 'getCollection');
var orderBy = new BasicDBObject(LAST_ACCESS_COLUMN, 1);
var semaphore = new java.util.concurrent.Semaphore(threads);
var executor = java.util.concurrent.Executors.newFixedThreadPool(threads);

var totalCounter = new java.util.concurrent.atomic.AtomicInteger(0);
var toDeleteCounter = new java.util.concurrent.atomic.AtomicInteger(0);

function deserialize(dbObject) {
    return invoke(mongoStoredResultDao, 'deserialize', dbObject);
}

function findResults(offset) {
    var query = mainCondition;
    if (offset.isPresent()) {
        var offsetCondition = new BasicDBObject(LAST_ACCESS_COLUMN, new BasicDBObject("$gt", offset.get().toDate()));
        var conditions = new BasicDBList();
        conditions.addAll(Cf.list(mainCondition, offsetCondition));
        query = new BasicDBObject('$and', conditions);    
    }
    return MongoDbUtils.findSortedLimited(dbCollection, query, Option.of(orderBy), Option.of(limit), deserialize);
}

function handler(storedResult) {
    logger.info("processed {} results. current last access is {}", totalCounter.incrementAndGet(), storedResult.getLastAccess());
    if (!invoke(resultsCleanup, 'skipResult', storedResult)) {
        invoke(resultsCleanup, 'cleanupStoredResult', storedResult);
        logger.info("deleting file {} with last access time: {}", toDeleteCounter.incrementAndGet(), storedResult.getLastAccess());
    }
}

function deleteByLastAccessLessBatch(deleteHandler, initialOffset) {
    var results = Cf.list();
    var offset = initialOffset;
    do {
        results = findResults(offset);
        offset = results.lastO().map(function(sr) { return sr.getLastAccess();});

        results.forEach(function(r) {
            if (java.lang.Thread.currentThread().isInterrupted()) throw 'Interrupted';

            semaphore.acquire();

            executor.submit(function () {
                var id = r.getFileId() + ' ' + r.getConvertTargetType();
                try {
                    logger.info('going to delete: {}', id)
                    deleteHandler.apply(r);
                } catch (e) {
                    logger.error('failed to delete {}: {}', id, e)
                } finally {
                    semaphore.release();
                }
            }, null);
        });

    } while (results.isNotEmpty());
}

try {
    deleteByLastAccessLessBatch(f1V(handler), initialOffset);
} finally {
    executor.shutdown();
}
