importPackage(ru.yandex.chemodan.app.dataapi.api.db.ref);
importPackage(ru.yandex.chemodan.app.dataapi.api.user);
importPackage(ru.yandex.chemodan.app.dataapi.api.data.record);
importPackage(ru.yandex.chemodan.app.dataapi.api.data.field);
importPackage(ru.yandex.chemodan.app.dataapi.api.deltas);

var appName = 'yatelemost';
var databaseId = 'settings';

var collectionId = 'settings';
var srcRecordId = 'gridView';
var dstRecordId = 'gridView2';

var fieldId = 'value';
var newValue = 'default';

var threads = 100;
var semaphore = new java.util.concurrent.Semaphore(threads);
var executor = java.util.concurrent.Executors.newFixedThreadPool(threads);

var counter = new java.util.concurrent.atomic.AtomicInteger(0);

logger = ru.yandex.misc.log.mlf.LoggerFactory.getLogger('manualLogger');

function copyValue(uid_str) {
    var uid = DataApiUserId.parse(uid_str);
    var dbRef =  DatabaseRef.cons(Option.of(appName), databaseId);
    var userDbSpec = new UserDatabaseSpec(uid, dbRef);
    var database = dataApiManager.getOrCreateDatabase(userDbSpec);
    //----------------------------------------

    var srcRecordO = dataApiManager.getRecord(uid, database.dbRef().consColRef(collectionId).consRecordRef(srcRecordId));
    var dstRecordO = dataApiManager.getRecord(uid, database.dbRef().consColRef(collectionId).consRecordRef(dstRecordId));
    if (srcRecordO.isPresent() && !dstRecordO.isPresent()) {
        var currentValue = srcRecordO.get().getData().get(fieldId).stringValue();
        var insertRecordChange = new SimpleDataRecord(collectionId, dstRecordId, NamedDataField.string(fieldId, currentValue)).toInsertChange();
        var delta = new Delta(insertRecordChange);

        dataApiManager.applyDelta(database, RevisionCheckMode.PER_RECORD, delta);
        logger.info('patched {} {}', counter.incrementAndGet(), uid_str)
    } else {
        logger.info('skipping {}', uid_str);
    }
}

function replaceValue(uid_str) {
    var uid = DataApiUserId.parse(uid_str);
    var dbRef =  DatabaseRef.cons(Option.of(appName), databaseId);
    var userDbSpec = new UserDatabaseSpec(uid, dbRef);
    var database = dataApiManager.getOrCreateDatabase(userDbSpec);
    //----------------------------------------

    var srcRecordO = dataApiManager.getRecord(uid, database.dbRef().consColRef(collectionId).consRecordRef(srcRecordId));
    var dstRecordO = dataApiManager.getRecord(uid, database.dbRef().consColRef(collectionId).consRecordRef(dstRecordId));
    if (srcRecordO.isPresent() && dstRecordO.isPresent()) {
        var updateRecordChange = new SimpleDataRecord(collectionId, srcRecordId, NamedDataField.string(fieldId, newValue)).toUpdateChange();

        var delta = new Delta(updateRecordChange);

        dataApiManager.applyDelta(database, RevisionCheckMode.PER_RECORD, delta);
        logger.info('patched {} {}', counter.incrementAndGet(), uid_str)
    } else {
        logger.info('skipping {}', uid_str);
    }
}

var uids = (new File2("/tmp/uids_to_fix.txt")).readLines();

uids.forEach(function(uid) {
    semaphore.acquire();
    executor.submit(function () {
        try {
            copyValue(uid);
        } catch (e) {
            loggre.warn('failed to patch {}: {}', uid, e)
        } finally {
            semaphore.release();
        }
    }, null);
});

//////////////////////////////////////////

var threads = 100;
var semaphore = new java.util.concurrent.Semaphore(threads);
var executor = java.util.concurrent.Executors.newFixedThreadPool(threads);

var counter = new java.util.concurrent.atomic.AtomicInteger(0);

var uids = (new File2("/tmp/uids_to_fix.txt")).readLines();

uids.forEach(function(uid) {
    semaphore.acquire();
    executor.submit(function () {
        try {
            replaceValue(uid);
        } catch (e) {
            loggre.warn('failed to patch {}: {}', uid, e)
        } finally {
            semaphore.release();
        }
    }, null);
});
