importPackage(ru.yandex.chemodan.app.dataapi.api.user)

new Array('', '0', '0V', '1B', '1I', '1V', '2', '2V', '2B', '3', '3B', '3I', '3V').forEach(function(suffix) {
    this['f' + suffix] = function(func) {
        return new (Java.extend(ru.yandex.bolts['function']['Function' + suffix], {
            apply: function() {
                return func.apply(this, arguments);
            }
        }))()
    };
});

var log = ru.yandex.misc.log.mlf.LoggerFactory.getLogger("notes-stats")

var uids = notesJdbcTemplate.queryForList("Select distinct uid from note where delete_date is null", new java.lang.String("").getClass())
    .map(function (uid) {return DataApiUserId.parse(uid);})

var counter = 0;

function noteContent(uid, note) {
    var contentLength = 0;
    try {
        var out = new ru.yandex.misc.web.servlet.mock.MockHttpServletResponse();
        var respX = ru.yandex.misc.web.servlet.HttpServletResponseX.wrap(out);
        notesManager.getContent(uid, note.id, respX, Option.empty());
        contentLength = out.getContentAsString().length();
    } catch(ignore) {}
    return Tuple2List.fromPairs(
        'uid', uid, 
        'contentLength', contentLength,
        'title_length', note.title.length(),
        'snippet_length', note.snippet.getOrElse('').length(),
        'is_deleted', note.tags.containsTs(new java.lang.Long(1)));
}

var statsWUid = uids.flatMap(function(uid) {
    counter += 1;
    log.info("getting stats " + counter + "/" + uids.size());
    try {
        var notes = notesManager.listNotes(uid);
        return notes.map(function(note) {return noteContent(uid, note)});
    } catch (e) {
        log.info("failed to get stats for " + uid)
        return Cf.list();
    }
})

var file = new File2('/tmp/notes_contents').asAppendOutputStreamTool();

statsWUid.forEach(function (l) {
    file.writeLine(l.map(f2(function(key, value) {return '"' + key +'": ' + value;})).mkString('{', ', ', '}'))
})