#!/usr/bin/env python
# -*- coding: utf-8 -*-

from __future__ import absolute_import

from celery import Celery, Task

from celery_custom import Consumer, TaskPool

from time import sleep, time

from random import randint

# URL = 'guest:guest@localhost'
URL = 'disk_test_queller:eeTh5ohtho@queue01f.dst.yandex.net/disk_test_queller'
# URL = 'disk_test_queller:eeTh5ohtho@queue02f.dst.yandex.net/disk_test_queller'

app = Celery('tasks', broker='amqp://{url}'.format(url=URL))

app.conf.CELERYD_CONSUMER = Consumer
app.conf.CELERYD_POOL = TaskPool
app.conf.CELERYD_PREFETCH_MULTIPLIER = 1
app.conf.CELERY_ACKS_LATE = True
app.conf.CELERY_DEFAULT_QUEUE = 'submit'
app.conf.CELERY_TASK_SERIALIZER = 'json'


class BaseTask(Task):
    max_retries = None

    def on_failure(self, exc, task_id, args, kwargs, einfo):
        kwargs['context'].update({'error': str(einfo.exception),
                                  'traceback': einfo.traceback})
        self.retry(kwargs=kwargs, exc=exc, throw=False,
                   countdown=0, queue='submit')

    def on_success(self, retval, task_id, args, kwargs):
        kwargs['context']['finished'] = int(time() * 1000)
        self.request.retries -= 1
        self.retry(kwargs=kwargs, throw=False, countdown=0, queue='completed')

    def __call__(self, *args, **kwargs):
        kwargs['context']['started'] = int(time() * 1000)

        self.request.retries -= 1
        self.retry(kwargs=kwargs, throw=False, countdown=0, queue='started')
        self.request.retries += 1

        return super(BaseTask, self).__call__(*args, **kwargs)


@app.task(base=BaseTask)
def add(x, y, context=None):
    sleep(randint(2, 5))
    return x + y


@app.task(base=BaseTask)
def add2(x, y, context=None):
    sleep(randint(2, 5))
    return x + y
